/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.model.listener;

import com.liferay.document.library.exportimport.data.handler.DLExportableRepositoryPublisher;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.staging.model.listener.StagingModelListener;
import java.util.Collection;
import java.util.HashSet;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class DLFileVersionStagingModelListener
extends BaseModelListener<DLFileVersion> {
    private static final Log _log = LogFactoryUtil.getLog(DLFileVersionStagingModelListener.class);
    private ServiceTrackerList<DLExportableRepositoryPublisher, DLExportableRepositoryPublisher> _dlExportableRepositoryPublishers;
    @Reference
    private StagingModelListener<DLFileEntry> _stagingModelListener;

    public void onAfterCreate(DLFileVersion dlFileVersion) throws ModelListenerException {
        if (dlFileVersion.getStatus() != 0) {
            return;
        }
        DLFileEntry dlFileEntry = null;
        try {
            dlFileEntry = dlFileVersion.getFileEntry();
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
            return;
        }
        Collection<Long> exportableRepositoryIds = this._getExportableRepositoryIds(dlFileEntry.getGroupId());
        if (!exportableRepositoryIds.contains(dlFileEntry.getRepositoryId())) {
            return;
        }
        this._stagingModelListener.onAfterCreate((BaseModel)dlFileEntry);
    }

    public void onAfterUpdate(DLFileVersion dlFileVersion) throws ModelListenerException {
        if (dlFileVersion.getStatus() != 0 && dlFileVersion.getStatus() != 8) {
            return;
        }
        DLFileEntry dlFileEntry = null;
        try {
            dlFileEntry = dlFileVersion.getFileEntry();
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
            return;
        }
        Collection<Long> exportableRepositoryIds = this._getExportableRepositoryIds(dlFileEntry.getGroupId());
        if (!exportableRepositoryIds.contains(dlFileEntry.getRepositoryId())) {
            return;
        }
        this._stagingModelListener.onAfterUpdate((BaseModel)dlFileEntry);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._dlExportableRepositoryPublishers = ServiceTrackerListFactory.open((BundleContext)bundleContext, DLExportableRepositoryPublisher.class);
    }

    @Deactivate
    protected void deactivate() {
        if (this._dlExportableRepositoryPublishers != null) {
            this._dlExportableRepositoryPublishers.close();
        }
    }

    private Collection<Long> _getExportableRepositoryIds(long groupId) {
        HashSet<Long> exportableRepositoryIds = new HashSet<Long>();
        exportableRepositoryIds.add(groupId);
        for (DLExportableRepositoryPublisher dlExportableRepositoryPublisher : this._dlExportableRepositoryPublishers) {
            dlExportableRepositoryPublisher.publish(groupId, exportableRepositoryIds::add);
        }
        return exportableRepositoryIds;
    }
}

