/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.dispatch.model.impl;

import com.liferay.dispatch.model.DispatchLog;
import com.liferay.dispatch.service.DispatchLogLocalServiceUtil;

/**
 * The extended model base implementation for the DispatchLog service. Represents a row in the &quot;DispatchLog&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DispatchLogImpl}.
 * </p>
 *
 * @author Matija Petanjek
 * @see DispatchLogImpl
 * @see DispatchLog
 * @generated
 */
public abstract class DispatchLogBaseImpl
	extends DispatchLogModelImpl implements DispatchLog {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a dispatch log model instance should use the <code>DispatchLog</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			DispatchLogLocalServiceUtil.addDispatchLog(this);
		}
		else {
			DispatchLogLocalServiceUtil.updateDispatchLog(this);
		}
	}

}