/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.data.engine.model.impl;

import com.liferay.data.engine.model.DEDataListView;
import com.liferay.data.engine.service.DEDataListViewLocalServiceUtil;

/**
 * The extended model base implementation for the DEDataListView service. Represents a row in the &quot;DEDataListView&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DEDataListViewImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DEDataListViewImpl
 * @see DEDataListView
 * @generated
 */
public abstract class DEDataListViewBaseImpl
	extends DEDataListViewModelImpl implements DEDataListView {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a de data list view model instance should use the <code>DEDataListView</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			DEDataListViewLocalServiceUtil.addDEDataListView(this);
		}
		else {
			DEDataListViewLocalServiceUtil.updateDEDataListView(this);
		}
	}

}