/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.cleanup.internal.verify;

import com.liferay.data.cleanup.internal.verify.PostUpgradeDataCleanupProcess;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ClassNamePostUpgradeDataCleanupProcess
implements PostUpgradeDataCleanupProcess {
    private static final Log _log = LogFactoryUtil.getLog(ClassNamePostUpgradeDataCleanupProcess.class);
    private final ClassNameLocalService _classNameLocalService;
    private final Connection _connection;

    public ClassNamePostUpgradeDataCleanupProcess(ClassNameLocalService classNameLocalService, Connection connection) {
        this._classNameLocalService = classNameLocalService;
        this._connection = connection;
    }

    @Override
    public void cleanUp() throws Exception {
        BundleContext bundleContext = SystemBundleUtil.getBundleContext();
        for (Bundle bundle : bundleContext.getBundles()) {
            String bundleSymbolicName = bundle.getSymbolicName();
            if (!bundleSymbolicName.startsWith("com.liferay.") || bundle.getState() != 2) continue;
            if (_log.isWarnEnabled()) {
                _log.warn((Object)StringBundler.concat((String[])new String[]{ClassNamePostUpgradeDataCleanupProcess.class.getSimpleName(), " cannot be executed because there are modules ", "with unsatisfied references"}));
            }
            return;
        }
        List classNames = this._classNameLocalService.getClassNames(-1, -1);
        DBInspector dbInspector = new DBInspector(this._connection);
        HashSet models = new HashSet(ModelHintsUtil.getModels());
        for (ClassName className : classNames) {
            String value = className.getValue();
            if (!value.startsWith("com.liferay.")) continue;
            int dashIndex = value.indexOf("-");
            int poundIndex = value.indexOf("#");
            if (dashIndex != -1) {
                value = value.substring(0, dashIndex);
            }
            if (poundIndex != -1) {
                value = value.substring(0, poundIndex);
            }
            if (models.contains(value)) continue;
            Class clazz = null;
            for (Bundle bundle : bundleContext.getBundles()) {
                try {
                    clazz = bundle.loadClass(value);
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Throwable)classNotFoundException);
                }
            }
            if (clazz != null) continue;
            List tableNames = dbInspector.getTableNames(null);
            HashSet<String> usedTableNames = new HashSet<String>();
            tableNames.remove(dbInspector.normalizeName("ClassName_"));
            for (String tableName : tableNames) {
                if (!dbInspector.hasColumn(tableName, "classNameId")) continue;
                PreparedStatement preparedStatement = this._connection.prepareStatement("select 1 from " + tableName + " where classNameId = ?");
                try {
                    preparedStatement.setLong(1, className.getClassNameId());
                    ResultSet resultSet = preparedStatement.executeQuery();
                    try {
                        if (!resultSet.next()) continue;
                        usedTableNames.add(tableName);
                    }
                    finally {
                        if (resultSet == null) continue;
                        resultSet.close();
                    }
                }
                finally {
                    if (preparedStatement == null) continue;
                    preparedStatement.close();
                }
            }
            try (PreparedStatement preparedStatement = this._connection.prepareStatement("select 1 from ResourcePermission where name = ?");){
                preparedStatement.setString(1, value);
                try (ResultSet resultSet = preparedStatement.executeQuery();){
                    if (resultSet.next()) {
                        usedTableNames.add(dbInspector.normalizeName("ResourcePermission"));
                    }
                }
            }
            if (usedTableNames.isEmpty()) {
                this._classNameLocalService.deleteClassName(className);
                if (!_log.isInfoEnabled()) continue;
                _log.info((Object)("Class name " + value + " has been deleted because it is not in use"));
                continue;
            }
            if (!_log.isInfoEnabled()) continue;
            _log.info((Object)StringBundler.concat((String[])new String[]{"Class name ", value, " has not been found but is referenced in the next ", "tables: ", String.join((CharSequence)", ", new TreeSet(usedTableNames))}));
        }
    }
}

