/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.cleanup.internal.upgrade.executor;

import com.liferay.data.cleanup.internal.configuration.DataCleanupConfiguration;
import com.liferay.data.cleanup.internal.upgrade.AmazonRankingsUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.ChatUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.CurrencyConverterUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.DictionaryUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.DirectoryUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.DocumentLibraryFileRankServiceUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.FrontendImageEditorUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.GoogleMapsUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.HTMLPreviewUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.HelloVelocityUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.InvitationUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.LoanCalculatorUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.MailReaderUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.NetworkUtilitiesUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.OAuthUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.OpenSocialUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.PasswordGeneratorUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.PortalSecurityWedeployAuthUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.QuickNoteUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.RecentDocumentsUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.ShoppingUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.SocialActivityUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.SocialGroupStatisticsUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.SocialPrivateMessagingUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.SocialRequestsUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.SocialUserStatisticsUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.SoftwareCatalogUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.SyncUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.TranslatorUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.TwitterUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.UnitConverterUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.UpgradeHelloWorld;
import com.liferay.data.cleanup.internal.upgrade.WeatherUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.WebFormUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.WebProxyUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.WysiwygUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.XSLContentUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.YoutubeUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.util.ConfigurationUtil;
import com.liferay.expando.kernel.service.ExpandoTableLocalService;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.message.boards.service.MBThreadLocalService;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.service.ReleaseLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.felix.cm.PersistenceManager;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.data.cleanup.internal.configuration.DataCleanupConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={})
public class DataCleanupExecutor {
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private ExpandoTableLocalService _expandoTableLocalService;
    @Reference
    private ImageLocalService _imageLocalService;
    @Reference
    private MBMessageLocalService _mbMessageLocalService;
    @Reference
    private MBThreadLocalService _mbThreadLocalService;
    @Reference
    private PersistenceManager _persistenceManager;
    @Reference
    private RatingsStatsLocalService _ratingsStatsLocalService;
    @Reference
    private ReleaseLocalService _releaseLocalService;
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;

    @Activate
    protected void activate(Map<String, Object> properties) throws Exception {
        DataCleanupConfiguration dataCleanupConfiguration = (DataCleanupConfiguration)ConfigurableUtil.createConfigurable(DataCleanupConfiguration.class, properties);
        ConfigurationUtil.deleteConfiguration(this._configurationAdmin, this._persistenceManager, DataCleanupConfiguration.class.getName());
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpAmazonRankingsModuleData, "com.liferay.amazon.rankings.web", AmazonRankingsUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpChatModuleData, "com.liferay.chat.service", ChatUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpCurrencyConverterModuleData, "com.liferay.currency.converter.web", CurrencyConverterUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpDictionaryModuleData, "com.liferay.dictionary.web", DictionaryUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpDirectoryModuleData, "com.liferay.directory.web", DirectoryUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpDocumentLibraryFileRankModuleData, "com.liferay.document.library.file.rank.service", DocumentLibraryFileRankServiceUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpFrontendImageEditorModuleData, "com.liferay.frontend.image.editor.web", FrontendImageEditorUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpGoogleMapsModuleData, "com.liferay.google.maps.web", GoogleMapsUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpHelloVelocityModuleData, "com.liferay.hello.velocity.web", HelloVelocityUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpHelloWorldModuleData, "com.liferay.hello.world.web", UpgradeHelloWorld::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpHTMLPreviewModuleData, "com.liferay.html.preview.service", HTMLPreviewUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpInvitationModuleData, "com.liferay.invitation.web", InvitationUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpLoanCalculatorModuleData, "com.liferay.loan.calculator.web", LoanCalculatorUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpMailReaderModuleData, "com.liferay.mail.reader.service", MailReaderUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpNetworkUtilitiesModuleData, "com.liferay.network.utilities.web", NetworkUtilitiesUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpOAuthModuleData, "com.liferay.oauth.service", OAuthUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpPasswordGeneratorModuleData, "com.liferay.password.generator.web", PasswordGeneratorUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpPortalSecurityWedeployAuthModuleData, "com.liferay.portal.security.wedeploy.auth.service", PortalSecurityWedeployAuthUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpQuickNoteModuleData, "com.liferay.quick.note.web", QuickNoteUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpRecentDocumentsModuleData, "com.liferay.recent.documents.web", RecentDocumentsUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpShoppingModuleData, "com.liferay.shopping.service", () -> new ShoppingUpgradeProcess(this._imageLocalService));
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpSocialActivityModuleData, "com.liferay.social.activity.web", SocialActivityUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpSocialGroupStatisticsModuleData, "com.liferay.social.group.statistics.web", SocialGroupStatisticsUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpSocialPrivateMessagingModuleData, "com.liferay.social.privatemessaging.service", () -> new SocialPrivateMessagingUpgradeProcess(this._mbThreadLocalService));
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpSocialRequestsModuleData, "com.liferay.social.requests.web", SocialRequestsUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpSocialUserStatisticsModuleData, "com.liferay.social.user.statistics.web", SocialUserStatisticsUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpSoftwareCatalogModuleData, "com.liferay.softwarecatalog.service", () -> new SoftwareCatalogUpgradeProcess(this._imageLocalService, this._mbMessageLocalService, this._ratingsStatsLocalService, this._subscriptionLocalService));
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpSyncModuleData, "com.liferay.sync.service", SyncUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpTranslatorModuleData, "com.liferay.translator.web", TranslatorUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpTwitterModuleData, "com.liferay.twitter.service", TwitterUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpUnitConverterModuleData, "com.liferay.unit.converter.web", UnitConverterUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpWeatherModuleData, "com.liferay.weather.web", WeatherUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpWebFormModuleData, "com.liferay.web.form.web", WebFormUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpWebProxyModuleData, "com.liferay.web.proxy.web", WebProxyUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpWysiwygModuleData, "com.liferay.wysiwyg.web", WysiwygUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpXSLContentModuleData, "com.liferay.xsl.content.web", XSLContentUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpYoutubeModuleData, "com.liferay.youtube.web", YoutubeUpgradeProcess::new);
        this._cleanUpModuleData(dataCleanupConfiguration::cleanUpOpenSocialModuleData, "opensocial-portlet", () -> new OpenSocialUpgradeProcess(this._expandoTableLocalService));
    }

    private void _cleanUpModuleData(Supplier<Boolean> booleanSupplier, String servletContextName, Supplier<UpgradeProcess> upgradeProcessSupplier) throws Exception {
        Release release;
        if (booleanSupplier.get().booleanValue() && (release = this._releaseLocalService.fetchRelease(servletContextName)) != null) {
            UpgradeProcess upgradeProcess = upgradeProcessSupplier.get();
            upgradeProcess.upgrade();
            CacheRegistryUtil.clear();
        }
    }
}

