/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.cleanup.internal.upgrade;

import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.data.cleanup.internal.upgrade.BaseUpgradeProcess;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.model.FragmentEntryLinkModel;
import com.liferay.fragment.service.FragmentEntryLinkLocalService;
import com.liferay.layout.manager.ContentManager;
import com.liferay.layout.model.LayoutClassedModelUsage;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructureRelModel;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureRelLocalService;
import com.liferay.layout.service.LayoutClassedModelUsageLocalService;
import com.liferay.petra.function.UnsafeBiConsumer;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public class LayoutClassedModelUsageOrphanDataUpgradeProcess
extends BaseUpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(LayoutClassedModelUsageOrphanDataUpgradeProcess.class);
    private final ClassNameLocalService _classNameLocalService;
    private final ContentManager _contentManager;
    private final CTCollectionLocalService _ctCollectionLocalService;
    private final FragmentEntryLinkLocalService _fragmentEntryLinkLocalService;
    private final LayoutClassedModelUsageLocalService _layoutClassedModelUsageLocalService;
    private final LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    private final LayoutPageTemplateStructureRelLocalService _layoutPageTemplateStructureRelLocalService;

    public LayoutClassedModelUsageOrphanDataUpgradeProcess(ClassNameLocalService classNameLocalService, ContentManager contentManager, CTCollectionLocalService ctCollectionLocalService, FragmentEntryLinkLocalService fragmentEntryLinkLocalService, LayoutClassedModelUsageLocalService layoutClassedModelUsageLocalService, LayoutPageTemplateStructureLocalService layoutPageTemplateStructureLocalService, LayoutPageTemplateStructureRelLocalService layoutPageTemplateStructureRelLocalService) {
        this._classNameLocalService = classNameLocalService;
        this._contentManager = contentManager;
        this._ctCollectionLocalService = ctCollectionLocalService;
        this._fragmentEntryLinkLocalService = fragmentEntryLinkLocalService;
        this._layoutClassedModelUsageLocalService = layoutClassedModelUsageLocalService;
        this._layoutPageTemplateStructureLocalService = layoutPageTemplateStructureLocalService;
        this._layoutPageTemplateStructureRelLocalService = layoutPageTemplateStructureRelLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._cleanUpdateLayoutClassedModelUsages();
    }

    private void _cleanUpdateLayoutClassedModelUsages() throws Exception {
        this._processLayoutClassedModelUsages(this._classNameLocalService.getClassNameId(FragmentEntryLink.class.getName()), "fragmentEntryLinkId", "FragmentEntryLink", (UnsafeBiConsumer<Long, Long, Exception>)((UnsafeBiConsumer)this::_updateLayoutClassedModelUsagesForFragmentEntryLinks));
        this._processLayoutClassedModelUsages(this._classNameLocalService.getClassNameId(LayoutPageTemplateStructure.class.getName()), "layoutPageTemplateStructureId", "LayoutPageTemplateStructure", (UnsafeBiConsumer<Long, Long, Exception>)((UnsafeBiConsumer)this::_updateLayoutClassedModelUsagesForLayoutPageTemplateStructure));
    }

    private void _deleteOrphanLayoutClassedModelUsage(CTCollection ctCollection, long ctCollectionId, long layoutClassedModelUsageId) {
        block17: {
            try {
                LayoutClassedModelUsage layoutClassedModelUsage = this._layoutClassedModelUsageLocalService.fetchLayoutClassedModelUsage(layoutClassedModelUsageId);
                if (layoutClassedModelUsage == null || this._isCTCollectionReadOnly(ctCollection)) {
                    try (PreparedStatement preparedStatement = this.connection.prepareStatement("delete from LayoutClassedModelUsage where ctCollectionId = ? and layoutClassedModelUsageId = ?");){
                        preparedStatement.setLong(1, ctCollectionId);
                        preparedStatement.setLong(2, layoutClassedModelUsageId);
                        preparedStatement.executeUpdate();
                    }
                }
                try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)ctCollectionId);){
                    this._layoutClassedModelUsageLocalService.deleteLayoutClassedModelUsage(layoutClassedModelUsage);
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Deleted orphaned layout classed model usage ", layoutClassedModelUsageId, " with change tracking collection ID ", ctCollectionId}));
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block17;
                _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to delete orphaned layout classed model usage ", layoutClassedModelUsageId, " with change tracking collection ID ", ctCollectionId}), (Throwable)exception);
            }
        }
    }

    private boolean _isCTCollectionReadOnly(CTCollection ctCollection) {
        return ctCollection != null && ctCollection.isReadOnly();
    }

    private void _processLayoutClassedModelUsages(long classNameId, String keyColumnName, String tableName, UnsafeBiConsumer<Long, Long, Exception> unsafeBiConsumer) throws Exception {
        HashMap<Long, Map<Long, Set<Long>>> ctCollectionIdsMaps = new HashMap<Long, Map<Long, Set<Long>>>();
        try (PreparedStatement preparedStatement = this.connection.prepareStatement(SQLTransformer.transform((String)StringBundler.concat((String[])new String[]{"select ctCollectionId, layoutClassedModelUsageId, ", "groupId, plid from LayoutClassedModelUsage where ", "containerType = ? and (plid <> (select plid from ", tableName, " where ", keyColumnName, " = CAST_LONG(containerKey) and ", "LayoutClassedModelUsage.ctCollectionId = ", tableName, ".ctCollectionId) or (not exists (select 1 from ", tableName, " where ", keyColumnName, " = CAST_LONG(containerKey) and ", "LayoutClassedModelUsage.ctCollectionId = ", tableName, ".ctCollectionId)))"})));){
            preparedStatement.setLong(1, classNameId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                while (resultSet.next()) {
                    long ctCollectionId = resultSet.getLong("ctCollectionId");
                    long layoutClassedModelUsageId = resultSet.getLong("layoutClassedModelUsageId");
                    CTCollection ctCollection = this._ctCollectionLocalService.fetchCTCollection(ctCollectionId);
                    this._deleteOrphanLayoutClassedModelUsage(ctCollection, ctCollectionId, layoutClassedModelUsageId);
                    if (this._isCTCollectionReadOnly(ctCollection)) continue;
                    long groupId = resultSet.getLong("groupId");
                    long plid = resultSet.getLong("plid");
                    Map ctCollectionIdsMap = ctCollectionIdsMaps.computeIfAbsent(groupId, key -> new HashMap());
                    Set plids = ctCollectionIdsMap.computeIfAbsent(ctCollectionId, key -> new HashSet());
                    plids.add(plid);
                }
            }
        }
        this._processLayoutClassedModelUsages(ctCollectionIdsMaps, unsafeBiConsumer);
    }

    private void _processLayoutClassedModelUsages(Map<Long, Map<Long, Set<Long>>> ctCollectionIdsMaps, UnsafeBiConsumer<Long, Long, Exception> unsafeBiConsumer) {
        for (Map.Entry<Long, Map<Long, Set<Long>>> entry1 : ctCollectionIdsMaps.entrySet()) {
            long groupId = entry1.getKey();
            Map<Long, Set<Long>> ctCollectionIdsMap = entry1.getValue();
            for (Map.Entry<Long, Set<Long>> entry2 : ctCollectionIdsMap.entrySet()) {
                long ctCollectionId = entry2.getKey();
                Set<Long> plids = entry2.getValue();
                for (long plid : plids) {
                    try {
                        SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)ctCollectionId);
                        try {
                            unsafeBiConsumer.accept((Object)groupId, (Object)plid);
                            if (!_log.isDebugEnabled()) continue;
                            _log.debug((Object)StringBundler.concat((Object[])new Object[]{"Updated layout classed model usage with ", "change tracking collection ID ", ctCollectionId, " and PLID ", plid}));
                        }
                        finally {
                            if (safeCloseable == null) continue;
                            safeCloseable.close();
                        }
                    }
                    catch (Exception exception) {
                        if (!_log.isWarnEnabled()) continue;
                        _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Unable to update layout classed model ", "usage with change tracking collection ID ", ctCollectionId, " and PLID ", plid}), (Throwable)exception);
                    }
                }
            }
        }
    }

    private <T> void _updateLayoutClassedModelUsages(Consumer<T> consumer, Function<T, ?> function, List<T> items, String logPrefix) {
        for (T item : items) {
            if (item == null) continue;
            try {
                consumer.accept(item);
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)(logPrefix + String.valueOf(function.apply(item))), (Throwable)exception);
            }
        }
    }

    private void _updateLayoutClassedModelUsagesForFragmentEntryLinks(long groupId, long plid) {
        this._updateLayoutClassedModelUsages(arg_0 -> ((ContentManager)this._contentManager).updateLayoutClassedModelUsage(arg_0), FragmentEntryLinkModel::getFragmentEntryLinkId, this._fragmentEntryLinkLocalService.getFragmentEntryLinksByPlid(groupId, plid), "Unable to update layout classed model usages for fragment entry link ");
    }

    private void _updateLayoutClassedModelUsagesForLayoutPageTemplateStructure(long groupId, long plid) {
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(groupId, plid);
        if (layoutPageTemplateStructure == null) {
            return;
        }
        this._updateLayoutClassedModelUsages(arg_0 -> ((ContentManager)this._contentManager).updateLayoutClassedModelUsage(arg_0), LayoutPageTemplateStructureRelModel::getLayoutPageTemplateStructureRelId, this._layoutPageTemplateStructureRelLocalService.getLayoutPageTemplateStructureRels(layoutPageTemplateStructure.getLayoutPageTemplateStructureId()), "Unable to update layout classed model usages for layout page template structure relationship ");
    }
}

