/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.client.extension.util.spring.boot3;

import com.liferay.client.extension.util.spring.boot3.LiferayOAuth2Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.core.env.Environment;
import org.springframework.security.oauth2.client.AuthorizedClientServiceOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.AuthorizedClientServiceReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.InMemoryOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.InMemoryReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientProviderBuilder;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.ReactiveOAuth2AuthorizedClientService;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.ReactiveClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.reactive.function.client.ServerOAuth2AuthorizedClientExchangeFilterFunction;
import org.springframework.security.oauth2.core.AuthorizationGrantType;
import org.springframework.security.oauth2.core.ClientAuthenticationMethod;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

@Configuration
public class LiferayOAuth2ClientConfiguration {
    @Autowired
    private Environment _environment;
    @Autowired(required=false)
    @Qualifier(value="extra")
    private InMemoryClientRegistrationRepository _extraInMemoryClientRegistrationRepository;
    @Autowired(required=false)
    @Qualifier(value="extra")
    private InMemoryReactiveClientRegistrationRepository _extraInMemoryReactiveClientRegistrationRepository;
    @Value(value="${com.liferay.lxc.dxp.domains}")
    private String _lxcDXPDomains;
    @Value(value="${com.liferay.lxc.dxp.mainDomain}")
    private String _lxcDXPMainDomain;
    @Value(value="${com.liferay.lxc.dxp.server.protocol}")
    private String _lxcDXPServerProtocol;

    @Bean
    public AuthorizedClientServiceOAuth2AuthorizedClientManager authorizedClientServiceOAuth2AuthorizedClientManager(ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientService oAuth2AuthorizedClientService) {
        AuthorizedClientServiceOAuth2AuthorizedClientManager authorizedClientServiceOAuth2AuthorizedClientManager = new AuthorizedClientServiceOAuth2AuthorizedClientManager(clientRegistrationRepository, oAuth2AuthorizedClientService);
        authorizedClientServiceOAuth2AuthorizedClientManager.setAuthorizedClientProvider(OAuth2AuthorizedClientProviderBuilder.builder().clientCredentials().build());
        return authorizedClientServiceOAuth2AuthorizedClientManager;
    }

    @Bean
    @Primary
    public ClientRegistrationRepository clientRegistrationRepository() {
        List<ClientRegistration> clientRegistrations = this._getClientRegistrations();
        if (this._extraInMemoryClientRegistrationRepository != null) {
            this._extraInMemoryClientRegistrationRepository.forEach(clientRegistrations::add);
        }
        if (!clientRegistrations.isEmpty()) {
            return new InMemoryClientRegistrationRepository(clientRegistrations.toArray(new ClientRegistration[0]));
        }
        return new InMemoryClientRegistrationRepository(Collections.emptyMap());
    }

    @Bean
    @Primary
    public ReactiveClientRegistrationRepository clientRegistrations() {
        List<ClientRegistration> clientRegistrations = this._getClientRegistrations();
        if (this._extraInMemoryReactiveClientRegistrationRepository != null) {
            this._extraInMemoryReactiveClientRegistrationRepository.forEach(clientRegistrations::add);
        }
        if (!clientRegistrations.isEmpty()) {
            return new InMemoryReactiveClientRegistrationRepository(clientRegistrations.toArray(new ClientRegistration[0]));
        }
        return new ReactiveClientRegistrationRepository(){

            public Mono<ClientRegistration> findByRegistrationId(String registrationId) {
                return Mono.empty();
            }
        };
    }

    @Bean
    public OAuth2AuthorizedClientService oAuth2AuthorizedClientService(ClientRegistrationRepository clientRegistrationRepository) {
        return new InMemoryOAuth2AuthorizedClientService(clientRegistrationRepository);
    }

    @Bean
    public WebClient webClient(ReactiveClientRegistrationRepository reactiveClientRegistrationRepository) {
        return WebClient.builder().filter((ExchangeFilterFunction)new ServerOAuth2AuthorizedClientExchangeFilterFunction((ReactiveOAuth2AuthorizedClientManager)new AuthorizedClientServiceReactiveOAuth2AuthorizedClientManager(reactiveClientRegistrationRepository, (ReactiveOAuth2AuthorizedClientService)new InMemoryReactiveOAuth2AuthorizedClientService(reactiveClientRegistrationRepository)))).build();
    }

    private List<ClientRegistration> _getClientRegistrations() {
        String liferayOauthApplicationExternalReferenceCodes = this._environment.getProperty("liferay.oauth.application.external.reference.codes");
        if (liferayOauthApplicationExternalReferenceCodes == null) {
            throw new IllegalArgumentException("Property \"liferay.oauth.application.external.reference.codes\" is not defined");
        }
        ArrayList<ClientRegistration> clientRegistrations = new ArrayList<ClientRegistration>();
        for (String externalReferenceCode : liferayOauthApplicationExternalReferenceCodes.split(",")) {
            String clientSecret;
            String clientId = this._environment.getProperty(externalReferenceCode + ".oauth2.headless.server.client.id");
            if (clientId == null) {
                clientId = LiferayOAuth2Util.getClientId(externalReferenceCode, this._lxcDXPMainDomain, this._lxcDXPServerProtocol);
            }
            if (clientId == null || (clientSecret = this._environment.getProperty(externalReferenceCode + ".oauth2.headless.server.client.secret")) == null) continue;
            Object tokenURI = this._environment.getProperty(externalReferenceCode + ".oauth2.token.uri", "/o/oauth2/token");
            if (!((String)tokenURI).contains("://")) {
                tokenURI = this._lxcDXPServerProtocol + "://" + this._lxcDXPMainDomain + (String)tokenURI;
            }
            ClientRegistration clientRegistration = ClientRegistration.withRegistrationId((String)externalReferenceCode).tokenUri((String)tokenURI).clientId(clientId).clientSecret(clientSecret).authorizationGrantType(AuthorizationGrantType.CLIENT_CREDENTIALS).clientAuthenticationMethod(ClientAuthenticationMethod.CLIENT_SECRET_POST).build();
            clientRegistrations.add(clientRegistration);
        }
        return clientRegistrations;
    }
}

