/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.client.extension.util.spring.boot2;

import java.lang.invoke.LambdaMetafactory;
import java.net.URI;
import java.util.function.Function;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.security.oauth2.client.AuthorizedClientServiceOAuth2AuthorizedClientManager;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.core.OAuth2AccessToken;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriBuilder;

public class LiferayOAuth2Util {
    private static final Log _log = LogFactory.getLog(LiferayOAuth2Util.class);

    public static String getClientId(String externalReferenceCode, String lxcDXPMainDomain, String lxcDXPServerProtocol) {
        try {
            String baseURL = lxcDXPServerProtocol + "://" + lxcDXPMainDomain + "/o/oauth2/application";
            if (_log.isDebugEnabled()) {
                _log.debug((Object)new StringBuilder().append("Get client ID from ").append(baseURL).append(" using ").append(externalReferenceCode));
            }
            return ((ApplicationInfo)WebClient.create((String)baseURL).get().uri((Function<UriBuilder, URI>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$getClientId$0(java.lang.String org.springframework.web.util.UriBuilder ), (Lorg/springframework/web/util/UriBuilder;)Ljava/net/URI;)((String)externalReferenceCode)).retrieve().bodyToMono(ApplicationInfo.class).block()).client_id;
        }
        catch (Throwable throwable) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get client ID: " + throwable.getMessage()));
            }
            return null;
        }
    }

    public static OAuth2AccessToken getOAuth2AccessToken(AuthorizedClientServiceOAuth2AuthorizedClientManager authorizedClientServiceOAuth2AuthorizedClientManager, String externalReferenceCode) {
        OAuth2AuthorizeRequest.Builder oAuth2AuthorizeRequestBuilder = OAuth2AuthorizeRequest.withClientRegistrationId((String)externalReferenceCode).principal(externalReferenceCode);
        OAuth2AuthorizedClient oAuth2AuthorizedClient = authorizedClientServiceOAuth2AuthorizedClientManager.authorize(oAuth2AuthorizeRequestBuilder.build());
        if (oAuth2AuthorizedClient == null) {
            _log.error((Object)"Unable to get OAuth 2 authorized client");
            return null;
        }
        OAuth2AccessToken oAuth2AccessToken = oAuth2AuthorizedClient.getAccessToken();
        if (oAuth2AccessToken == null) {
            _log.error((Object)"Unable to get OAuth 2 access token");
            return null;
        }
        return oAuth2AccessToken;
    }

    private static /* synthetic */ URI lambda$getClientId$0(String externalReferenceCode, UriBuilder uriBuilder) {
        return uriBuilder.queryParam("externalReferenceCode", new Object[]{externalReferenceCode}).build(new Object[0]);
    }

    private static class ApplicationInfo {
        public String client_id;

        private ApplicationInfo() {
        }
    }
}

