/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.changeset.model.impl;

/**
 * The extended model implementation for the ChangesetCollection service.
 * Represents a row in the &quot;ChangesetCollection&quot; database table, with
 * each column mapped to a property of this class.
 *
 * <p>
 * Helper methods and all application logic should be put in this class.
 * Whenever methods are added, rerun ServiceBuilder to copy their definitions
 * into the {@link com.liferay.changeset.model.ChangesetCollection} interface.
 * </p>
 *
 * @author Brian Wing Shun Chan
 */
public class ChangesetCollectionImpl extends ChangesetCollectionBaseImpl {

	/**
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never reference this class directly. All methods that expect a changeset
	 * collection model instance should use the {@link
	 * com.liferay.changeset.model.ChangesetCollection} interface instead.
	 */

}