/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.unit;

import com.liferay.batch.engine.BatchEngineTaskContentType;
import com.liferay.batch.engine.internal.bundle.AdvancedBundleBatchEngineUnitImpl;
import com.liferay.batch.engine.internal.bundle.ClassicBundleBatchEngineUnitImpl;
import com.liferay.batch.engine.unit.BatchEngineUnit;
import com.liferay.batch.engine.unit.BatchEngineUnitConfiguration;
import com.liferay.batch.engine.unit.BatchEngineUnitMetaInfo;
import com.liferay.batch.engine.unit.BatchEngineUnitReader;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.io.Deserializer;
import com.liferay.petra.io.Serializer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={BatchEngineUnitReader.class})
public class BatchEngineUnitReaderImpl
implements BatchEngineUnitReader {
    private static final Log _log = LogFactoryUtil.getLog(BatchEngineUnitReaderImpl.class);
    @Reference
    private CompanyLocalService _companyLocalService;

    public Collection<BatchEngineUnit> getBatchEngineUnits(Bundle bundle) {
        Dictionary headers = bundle.getHeaders("");
        String batchPath = (String)headers.get("Liferay-Client-Extension-Batch");
        if (batchPath != null) {
            if (batchPath.isEmpty()) {
                batchPath = ".";
            }
            if (StringUtil.startsWith((String)batchPath, (String)"/")) {
                batchPath = batchPath.substring(1);
            }
            if (!StringUtil.endsWith((String)batchPath, (String)"/")) {
                batchPath = batchPath.concat("/");
            }
            return this._getBatchEngineBundleUnitsCollection(bundle, batchPath);
        }
        return Collections.emptyList();
    }

    private String _getBatchEngineBundleEntryKey(URL url) {
        String zipEntryName = url.getPath();
        if (this._isBatchEngineTechnical(zipEntryName)) {
            return zipEntryName;
        }
        if (!zipEntryName.contains("/")) {
            return "/";
        }
        return zipEntryName.substring(0, zipEntryName.lastIndexOf("/") + 1);
    }

    private Collection<BatchEngineUnit> _getBatchEngineBundleUnitsCollection(Bundle bundle, String batchPath) {
        List<BatchEngineUnit> batchEngineUnits = this._loadBatchEngineUnits(bundle);
        if (batchEngineUnits != null) {
            return batchEngineUnits;
        }
        batchEngineUnits = new ArrayList<BatchEngineUnit>();
        TreeMap<String, List> bundleBatchEngineUnitURLs = new TreeMap<String, List>((Comparator<String>)new NaturalOrderStringComparator());
        Enumeration enumeration = bundle.findEntries(batchPath, "*", true);
        while (enumeration.hasMoreElements()) {
            URL url = (URL)enumeration.nextElement();
            if (StringUtil.endsWith((String)url.getPath(), (String)"/")) continue;
            bundleBatchEngineUnitURLs.compute(this._getBatchEngineBundleEntryKey(url), (k, urls) -> {
                if (urls == null) {
                    urls = new ArrayList<URL>();
                }
                urls.add(url);
                return urls;
            });
        }
        long bundleCompanyId = -1L;
        Dictionary headers = bundle.getHeaders("");
        String liferayVirtualInstanceId = (String)headers.get("Liferay-Virtual-Instance-Id");
        if (liferayVirtualInstanceId != null) {
            try {
                Company company = this._companyLocalService.getCompanyByWebId(liferayVirtualInstanceId);
                bundleCompanyId = company.getCompanyId();
            }
            catch (PortalException portalException) {
                _log.error((Object)("Unable to get company ID by web ID " + liferayVirtualInstanceId), (Throwable)portalException);
            }
        }
        for (Map.Entry entry : bundleBatchEngineUnitURLs.entrySet()) {
            List urls2 = (List)entry.getValue();
            if (this._isBatchEngineTechnical((String)entry.getKey())) {
                URL url = (URL)urls2.get(0);
                AdvancedBundleBatchEngineUnitImpl advancedBundleBatchEngineUnitImpl = new AdvancedBundleBatchEngineUnitImpl(bundle, url);
                if (!advancedBundleBatchEngineUnitImpl.isValid()) continue;
                advancedBundleBatchEngineUnitImpl.setBatchEngineUnitMetaInfo(this._toBatchEngineUnitMetaInfo((BatchEngineUnit)advancedBundleBatchEngineUnitImpl, bundleCompanyId, Arrays.asList(url)));
                batchEngineUnits.add((BatchEngineUnit)advancedBundleBatchEngineUnitImpl);
                continue;
            }
            ClassicBundleBatchEngineUnitImpl classicBundleBatchEngineUnitImpl = new ClassicBundleBatchEngineUnitImpl(bundle, urls2);
            if (!classicBundleBatchEngineUnitImpl.isValid()) continue;
            classicBundleBatchEngineUnitImpl.setBatchEngineUnitMetaInfo(this._toBatchEngineUnitMetaInfo((BatchEngineUnit)classicBundleBatchEngineUnitImpl, bundleCompanyId, urls2));
            batchEngineUnits.add((BatchEngineUnit)classicBundleBatchEngineUnitImpl);
        }
        this._saveBatchEngineUnits(bundle, batchEngineUnits);
        return batchEngineUnits;
    }

    private String _getFeatureFlagKey(BatchEngineUnitConfiguration batchEngineUnitConfiguration) {
        Map parameters = batchEngineUnitConfiguration.getParameters();
        if (parameters == null) {
            return "";
        }
        return GetterUtil.getString(parameters.get("featureFlag"));
    }

    private boolean _isBatchEngineTechnical(String zipEntryName) {
        return zipEntryName.endsWith(BatchEngineTaskContentType.JSONT.getFileExtension());
    }

    private List<BatchEngineUnit> _loadBatchEngineUnits(Bundle bundle) {
        File file = bundle.getDataFile("batchEngineUnits.data");
        if (!file.exists()) {
            return null;
        }
        try {
            Deserializer deserializer = new Deserializer(ByteBuffer.wrap(FileUtil.getBytes((File)file)));
            if (deserializer.readLong() == bundle.getLastModified()) {
                ArrayList<BatchEngineUnit> batchEngineUnits = new ArrayList<BatchEngineUnit>();
                int size = deserializer.readInt();
                for (int i = 0; i < size; ++i) {
                    BatchEngineUnitMetaInfo batchEngineUnitMetaInfo = BatchEngineUnitMetaInfo.readFrom((Deserializer)deserializer);
                    batchEngineUnits.add(this._toBatchEngineUnit(bundle, batchEngineUnitMetaInfo));
                }
                return batchEngineUnits;
            }
        }
        catch (IOException ioException) {
            _log.error((Object)"Unable to read batch engine units", (Throwable)ioException);
        }
        return null;
    }

    private void _saveBatchEngineUnits(Bundle bundle, List<BatchEngineUnit> batchEngineUnits) {
        Serializer serializer = new Serializer();
        serializer.writeLong(bundle.getLastModified());
        serializer.writeInt(batchEngineUnits.size());
        try (FileOutputStream outputStream = new FileOutputStream(bundle.getDataFile("batchEngineUnits.data"));){
            for (BatchEngineUnit batchEngineUnit : batchEngineUnits) {
                BatchEngineUnitMetaInfo batchEngineUnitMetaInfo = batchEngineUnit.getBatchEngineUnitMetaInfo();
                batchEngineUnitMetaInfo.writeTo(serializer);
            }
            serializer.writeTo((OutputStream)outputStream);
        }
        catch (IOException ioException) {
            _log.error((Object)"Unable to write batch engine units", (Throwable)ioException);
        }
    }

    private BatchEngineUnit _toBatchEngineUnit(Bundle bundle, BatchEngineUnitMetaInfo batchEngineUnitMetaInfo) {
        Object[] paths = batchEngineUnitMetaInfo.getPaths();
        if (batchEngineUnitMetaInfo.isAdvanced()) {
            AdvancedBundleBatchEngineUnitImpl advancedBundleBatchEngineUnitImpl = new AdvancedBundleBatchEngineUnitImpl(bundle, bundle.getEntry((String)paths[0]));
            advancedBundleBatchEngineUnitImpl.setBatchEngineUnitMetaInfo(batchEngineUnitMetaInfo);
            return advancedBundleBatchEngineUnitImpl;
        }
        List urls = TransformUtil.transformToList((Object[])paths, path -> bundle.getEntry(path));
        ClassicBundleBatchEngineUnitImpl classicBundleBatchEngineUnitImpl = new ClassicBundleBatchEngineUnitImpl(bundle, urls);
        classicBundleBatchEngineUnitImpl.setBatchEngineUnitMetaInfo(batchEngineUnitMetaInfo);
        return classicBundleBatchEngineUnitImpl;
    }

    private BatchEngineUnitMetaInfo _toBatchEngineUnitMetaInfo(BatchEngineUnit batchEngineUnit, long bundleCompanyId, List<URL> urls) {
        try {
            BatchEngineUnitConfiguration batchEngineUnitConfiguration = batchEngineUnit.getBatchEngineUnitConfiguration();
            String[] paths = new String[urls.size()];
            for (int i = 0; i < urls.size(); ++i) {
                URL url = urls.get(i);
                paths[i] = url.getPath();
            }
            return new BatchEngineUnitMetaInfo(batchEngineUnit instanceof AdvancedBundleBatchEngineUnitImpl, bundleCompanyId > 0L ? bundleCompanyId : batchEngineUnitConfiguration.getCompanyId(), this._getFeatureFlagKey(batchEngineUnitConfiguration), batchEngineUnitConfiguration.isMultiCompany(), paths);
        }
        catch (IOException ioException) {
            _log.error((Object)"Unable to parse batch engine unit configuration", (Throwable)ioException);
            return null;
        }
    }
}

