/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.writer;

import com.liferay.batch.engine.BatchEngineTaskContentType;
import com.liferay.batch.engine.csv.ColumnDescriptorProvider;
import com.liferay.batch.engine.internal.writer.BatchEngineExportTaskItemWriter;
import com.liferay.batch.engine.internal.writer.CSVBatchEngineExportTaskItemWriterImpl;
import com.liferay.batch.engine.internal.writer.ItemClassIndexUtil;
import com.liferay.batch.engine.internal.writer.JSONBatchEngineExportTaskItemWriterImpl;
import com.liferay.batch.engine.internal.writer.JSONLBatchEngineExportTaskItemWriterImpl;
import com.liferay.batch.engine.internal.writer.JSONTBatchEngineExportTaskItemWriterImpl;
import com.liferay.batch.engine.internal.writer.XLSBatchEngineExportTaskItemWriterImpl;
import com.liferay.batch.engine.unit.BatchEngineUnitConfiguration;
import com.liferay.portal.kernel.util.ObjectValuePair;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BatchEngineExportTaskItemWriterBuilder {
    private BatchEngineTaskContentType _batchEngineTaskContentType;
    private ColumnDescriptorProvider _columnDescriptorProvider;
    private long _companyId;
    private String _csvFileColumnDelimiter;
    private List<String> _fieldNames;
    private Class<?> _itemClass;
    private OutputStream _outputStream;
    private Map<String, Serializable> _parameters;
    private String _taskItemDelegateName;
    private long _userId;

    public BatchEngineExportTaskItemWriterBuilder batchEngineTaskContentType(BatchEngineTaskContentType batchEngineTaskContentType) {
        this._batchEngineTaskContentType = batchEngineTaskContentType;
        return this;
    }

    public BatchEngineExportTaskItemWriter build() throws Exception {
        Map<String, ObjectValuePair<Field, Method>> fieldNameObjectValuePairs = ItemClassIndexUtil.index(this._itemClass);
        if (this._batchEngineTaskContentType == BatchEngineTaskContentType.CSV) {
            return new CSVBatchEngineExportTaskItemWriterImpl(this._columnDescriptorProvider, this._companyId, this._csvFileColumnDelimiter, fieldNameObjectValuePairs, this._fieldNames, this._outputStream, this._parameters, this._taskItemDelegateName);
        }
        if (this._batchEngineTaskContentType == BatchEngineTaskContentType.JSON) {
            return new JSONBatchEngineExportTaskItemWriterImpl(this._fieldNames, this._outputStream);
        }
        if (this._batchEngineTaskContentType == BatchEngineTaskContentType.JSONL) {
            return new JSONLBatchEngineExportTaskItemWriterImpl(this._fieldNames, this._outputStream);
        }
        if (this._batchEngineTaskContentType == BatchEngineTaskContentType.XLS || this._batchEngineTaskContentType == BatchEngineTaskContentType.XLSX) {
            return new XLSBatchEngineExportTaskItemWriterImpl(this._columnDescriptorProvider, this._companyId, fieldNameObjectValuePairs, this._fieldNames, this._outputStream, this._taskItemDelegateName);
        }
        if (this._batchEngineTaskContentType == BatchEngineTaskContentType.JSONT) {
            BatchEngineUnitConfiguration batchEngineUnitConfiguration = new BatchEngineUnitConfiguration();
            batchEngineUnitConfiguration.setClassName(this._itemClass.getName());
            batchEngineUnitConfiguration.setCompanyId(this._companyId);
            if (this._parameters == null) {
                this._parameters = new HashMap<String, Serializable>();
            }
            this._parameters.computeIfAbsent("createStrategy", key -> "INSERT");
            this._parameters.computeIfAbsent("importStrategy", key -> "ON_ERROR_FAIL");
            this._parameters.computeIfAbsent("updateStrategy", key -> "UPDATE");
            batchEngineUnitConfiguration.setParameters(this._parameters);
            batchEngineUnitConfiguration.setTaskItemDelegateName(this._taskItemDelegateName);
            batchEngineUnitConfiguration.setUserId(this._userId);
            batchEngineUnitConfiguration.setVersion("v1.0");
            return new JSONTBatchEngineExportTaskItemWriterImpl(batchEngineUnitConfiguration, this._fieldNames, this._outputStream);
        }
        throw new IllegalArgumentException("Unknown batch engine task content type " + String.valueOf(this._batchEngineTaskContentType));
    }

    public BatchEngineExportTaskItemWriterBuilder columnDescriptorProvider(ColumnDescriptorProvider columnDescriptorProvider) {
        this._columnDescriptorProvider = columnDescriptorProvider;
        return this;
    }

    public BatchEngineExportTaskItemWriterBuilder companyId(long companyId) {
        this._companyId = companyId;
        return this;
    }

    public BatchEngineExportTaskItemWriterBuilder csvFileColumnDelimiter(String csvFileColumnDelimiter) {
        this._csvFileColumnDelimiter = csvFileColumnDelimiter;
        return this;
    }

    public BatchEngineExportTaskItemWriterBuilder fieldNames(List<String> fieldNames) {
        this._fieldNames = fieldNames;
        return this;
    }

    public BatchEngineExportTaskItemWriterBuilder itemClass(Class<?> itemClass) {
        this._itemClass = itemClass;
        return this;
    }

    public BatchEngineExportTaskItemWriterBuilder outputStream(OutputStream outputStream) {
        this._outputStream = outputStream;
        return this;
    }

    public BatchEngineExportTaskItemWriterBuilder parameters(Map<String, Serializable> parameters) {
        this._parameters = parameters;
        return this;
    }

    public BatchEngineExportTaskItemWriterBuilder taskItemDelegateName(String taskItemDelegateName) {
        this._taskItemDelegateName = taskItemDelegateName;
        return this;
    }

    public BatchEngineExportTaskItemWriterBuilder userId(long userId) {
        this._userId = userId;
        return this;
    }
}

