/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.reader;

import com.liferay.batch.engine.internal.reader.BatchEngineImportTaskItemReader;
import com.liferay.batch.engine.internal.reader.FieldNameFilterFunction;
import com.liferay.batch.engine.internal.reader.FieldNameValueMapHandlerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class XLSBatchEngineImportTaskItemReaderImpl
implements BatchEngineImportTaskItemReader {
    private Function<Map<String, Object>, Map<String, Object>> _fieldNameFilter = map -> map;
    private final String[] _fieldNames;
    private final InputStream _inputStream;
    private final Iterator<Row> _iterator;
    private final Workbook _workbook;

    public XLSBatchEngineImportTaskItemReaderImpl(List<String> includeFieldNames, InputStream inputStream) throws IOException {
        if (!includeFieldNames.isEmpty()) {
            this._fieldNameFilter = new FieldNameFilterFunction(includeFieldNames);
        }
        this._inputStream = inputStream;
        this._workbook = new XSSFWorkbook(this._inputStream);
        Sheet sheet = this._workbook.getSheetAt(0);
        this._iterator = sheet.rowIterator();
        Row row = this._iterator.next();
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Cell cell : row) {
            columnNames.add(cell.getStringCellValue());
        }
        this._fieldNames = columnNames.toArray(new String[0]);
    }

    @Override
    public void close() throws IOException {
        this._inputStream.close();
        this._workbook.close();
    }

    @Override
    public Map<String, Object> read() throws Exception {
        if (!this._iterator.hasNext()) {
            return null;
        }
        Row row = this._iterator.next();
        HashMap<String, Object> fieldNameValueMap = new HashMap<String, Object>();
        int index = 0;
        for (Cell cell : row) {
            String fieldName;
            if ((fieldName = this._fieldNames[index++]) == null) continue;
            if (CellType.BOOLEAN == cell.getCellType()) {
                fieldNameValueMap.put(fieldName, cell.getBooleanCellValue());
                continue;
            }
            if (CellType.NUMERIC == cell.getCellType()) {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    fieldNameValueMap.put(fieldName, cell.getDateCellValue());
                    continue;
                }
                fieldNameValueMap.put(fieldName, cell.getNumericCellValue());
                continue;
            }
            FieldNameValueMapHandlerFactory.FieldNameValueMapHandler fieldNameValueMapHandler = FieldNameValueMapHandlerFactory.getFieldNameValueMapHandler(fieldName);
            fieldNameValueMapHandler.handle(fieldName, fieldNameValueMap, cell.getStringCellValue());
        }
        return this._fieldNameFilter.apply(fieldNameValueMap);
    }
}

