/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.reader;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.liferay.batch.engine.BatchEngineTaskContentType;
import com.liferay.batch.engine.action.ItemReaderPostAction;
import com.liferay.batch.engine.exception.BatchEngineImportTaskExecutorException;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.jackson.databind.ObjectMapperProviderUtil;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BatchEngineImportTaskItemReaderUtil {
    private static final ObjectMapper _csvMapObjectMapper = new ObjectMapper(){
        {
            SimpleModule simpleModule = new SimpleModule();
            simpleModule.addDeserializer(Map.class, (JsonDeserializer)new MapStdCSVDeserializer());
            this.registerModule((Module)simpleModule);
        }
    };
    private static final Pattern _multiselectPicklistPattern = Pattern.compile("key_\\d+|name_\\d+");
    private static final ObjectMapper _objectMapper = new ObjectMapper(){
        {
            SimpleModule simpleModule = new SimpleModule();
            this.registerModule((Module)simpleModule);
        }
    };

    public static <T> T convertValue(BatchEngineImportTask batchEngineImportTask, Class<T> itemClass, Map<String, Object> fieldNameValueMap, List<ItemReaderPostAction> itemReaderPostActions) throws BatchEngineImportTaskExecutorException {
        T item = null;
        try {
            Class<T> resolvedClass = BatchEngineImportTaskItemReaderUtil._resolveClass(fieldNameValueMap, itemClass);
            Constructor<T> constructor = resolvedClass.getDeclaredConstructor(new Class[0]);
            item = constructor.newInstance(new Object[0]);
            HashMap<String, Serializable> extendedProperties = new HashMap<String, Serializable>();
            BatchEngineImportTaskItemReaderUtil._processFieldNameValueMap(batchEngineImportTask, BatchEngineImportTaskItemReaderUtil._getDeclaredFields(itemClass, resolvedClass), extendedProperties, fieldNameValueMap, item);
            for (ItemReaderPostAction itemReaderPostAction : itemReaderPostActions) {
                itemReaderPostAction.run(batchEngineImportTask, extendedProperties, item);
            }
            return item;
        }
        catch (Exception exception) {
            throw new BatchEngineImportTaskExecutorException(item, (Throwable)exception);
        }
    }

    public static Map<String, Object> mapFieldNames(Map<String, ? extends Serializable> fieldNameMappingMap, Map<String, Object> fieldNameValueMap) {
        if (fieldNameMappingMap == null || fieldNameMappingMap.isEmpty()) {
            return fieldNameValueMap;
        }
        HashMap<String, Object> targetFieldNameValueMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : fieldNameValueMap.entrySet()) {
            String targetFieldName = (String)((Object)fieldNameMappingMap.get(entry.getKey()));
            if (Validator.isNotNull((String)targetFieldName)) {
                Object object = targetFieldNameValueMap.get(targetFieldName);
                if (object != null && object instanceof Map) {
                    Map map = (Map)object;
                    map.putAll((Map)entry.getValue());
                    continue;
                }
                targetFieldNameValueMap.put(targetFieldName, entry.getValue());
                continue;
            }
            String[] fieldNameParts = StringUtil.split((String)entry.getKey(), (String)".");
            targetFieldName = (String)((Object)fieldNameMappingMap.get(fieldNameParts[0]));
            if (Validator.isNull((String)targetFieldName)) continue;
            Matcher multiselectPicklistMatcher = _multiselectPicklistPattern.matcher(fieldNameParts[1]);
            if (multiselectPicklistMatcher.matches()) {
                if (fieldNameParts[1].startsWith("name_")) continue;
                List list = (List)targetFieldNameValueMap.computeIfAbsent(targetFieldName, key -> new ArrayList());
                list.add(entry.getValue());
                continue;
            }
            Map map = (Map)targetFieldNameValueMap.computeIfAbsent(targetFieldName, key -> new HashMap());
            for (int i = 1; i < fieldNameParts.length; ++i) {
                if (fieldNameParts.length - 1 > i) {
                    map = (Map)map.computeIfAbsent(fieldNameParts[i], key -> new HashMap());
                    continue;
                }
                map.put(fieldNameParts[i], entry.getValue());
            }
        }
        return targetFieldNameValueMap;
    }

    private static Field _getAnySetterField(Map<String, Field> fields) {
        for (Field field : fields.values()) {
            if (!field.isAnnotationPresent(JsonAnySetter.class)) continue;
            return field;
        }
        return null;
    }

    private static Set<String> _getBatchRestrictFieldNames(BatchEngineImportTask batchEngineImportTask) {
        Map parameters = batchEngineImportTask.getParameters();
        if (parameters == null) {
            return new HashSet<String>();
        }
        String batchRestrictFields = MapUtil.getString((Map)parameters, (Object)"batchRestrictFields");
        if (Validator.isBlank((String)batchRestrictFields)) {
            return new HashSet<String>();
        }
        return SetUtil.fromArray((Object[])StringUtil.split((String)batchRestrictFields));
    }

    private static Map<String, Field> _getDeclaredFields(Class<?> baseClass, Class<?> resolvedClass) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        for (Field field : baseClass.getDeclaredFields()) {
            fields.put(field.getName(), field);
        }
        if (Objects.equals(baseClass, resolvedClass)) {
            return fields;
        }
        for (Field field : resolvedClass.getDeclaredFields()) {
            fields.put(field.getName(), field);
        }
        return fields;
    }

    private static ObjectMapper _getObjectMapper(BatchEngineImportTask batchEngineImportTask, final Field field, Object value) throws Exception {
        if (StringUtil.equals((String)batchEngineImportTask.getParameterValue("importCreatorStrategy"), (String)"KEEP_CREATOR") && StringUtil.equals((String)field.getName(), (String)"creator")) {
            return new ObjectMapper(){
                {
                    this.addMixIn(field.getType(), CreatorMixin.class);
                }
            };
        }
        Object[] jsonDeserializes = (JsonDeserialize[])field.getAnnotationsByType(JsonDeserialize.class);
        if (ArrayUtil.isEmpty((Object[])jsonDeserializes)) {
            if (Objects.equals(batchEngineImportTask.getContentType(), BatchEngineTaskContentType.CSV.getFileExtension()) && BatchEngineImportTaskItemReaderUtil._isCSVMapColumn(field.getType(), value)) {
                return _csvMapObjectMapper;
            }
            return _objectMapper;
        }
        Object jsonDeserialize = jsonDeserializes[0];
        return new ObjectMapper((JsonDeserialize)jsonDeserialize){
            final /* synthetic */ JsonDeserialize val$jsonDeserialize;
            {
                this.val$jsonDeserialize = jsonDeserialize;
                SimpleModule simpleModule = new SimpleModule();
                simpleModule.addDeserializer(field.getType(), (JsonDeserializer)this.val$jsonDeserialize.using().newInstance());
                this.registerModule((Module)simpleModule);
            }
        };
    }

    private static boolean _isCSVMapColumn(Class<?> clazz, Object value) {
        if (!Map.class.isAssignableFrom(clazz)) {
            return false;
        }
        String string = value.toString();
        if (string == null || string.isEmpty()) {
            return false;
        }
        for (String line : string.split("\r\n")) {
            if (line.contains(":")) continue;
            return false;
        }
        return true;
    }

    private static void _processFieldNameValueMap(BatchEngineImportTask batchEngineImportTask, Map<String, Field> declaredFields, Map<String, Serializable> extendedProperties, Map<String, Object> fieldNameValueMap, Object item) throws Exception {
        Field anySetterField = BatchEngineImportTaskItemReaderUtil._getAnySetterField(declaredFields);
        Set<String> batchRestrictFieldNames = BatchEngineImportTaskItemReaderUtil._getBatchRestrictFieldNames(batchEngineImportTask);
        for (Map.Entry<String, Object> entry : fieldNameValueMap.entrySet()) {
            String name = entry.getKey();
            try {
                if (batchRestrictFieldNames.contains(name)) continue;
                Field field = declaredFields.get(name);
                if (field == null) {
                    field = declaredFields.get("_" + name);
                }
                if (field != null) {
                    BatchEngineImportTaskItemReaderUtil._setField(batchEngineImportTask, field, item, entry.getValue());
                    continue;
                }
                if (anySetterField != null) {
                    BatchEngineImportTaskItemReaderUtil._setField(anySetterField, item, name, entry.getValue());
                    continue;
                }
                extendedProperties.put(entry.getKey(), (Serializable)entry.getValue());
            }
            catch (Exception exception) {
                throw new Exception(StringBundler.concat((String[])new String[]{"Unable to set field ", name, ":", " ", exception.getMessage()}), exception);
            }
        }
    }

    private static <T> Class<? extends T> _resolveClass(Map<String, Object> fieldNameValueMap, Class<T> itemClass) {
        JsonTypeInfo jsonTypeInfo = itemClass.getAnnotation(JsonTypeInfo.class);
        if (jsonTypeInfo == null) {
            return itemClass;
        }
        String property = jsonTypeInfo.property();
        ObjectMapper objectMapper = ObjectMapperProviderUtil.getBatchEngineObjectMapper();
        Object value = objectMapper.convertValue((Object)HashMapBuilder.put((Object)property, (Object)fieldNameValueMap.get(property)).build(), itemClass);
        return value.getClass();
    }

    private static void _setField(BatchEngineImportTask batchEngineImportTask, Field field, Object item, Object value) throws Exception {
        field.setAccessible(true);
        ObjectMapper objectMapper = BatchEngineImportTaskItemReaderUtil._getObjectMapper(batchEngineImportTask, field, value);
        field.set(item, objectMapper.convertValue(value, field.getType()));
    }

    private static void _setField(Field field, Object item, String name, Object value) throws Exception {
        field.setAccessible(true);
        HashMap<String, Object> map = (HashMap<String, Object>)field.get(item);
        if (map == null) {
            map = new HashMap<String, Object>();
            field.set(item, map);
        }
        map.put(name, value);
    }

    private static class MapStdCSVDeserializer
    extends StdDeserializer<Map<String, Object>> {
        public MapStdCSVDeserializer() {
            this(Map.class);
        }

        public Map<String, Object> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            String string = jsonParser.getValueAsString();
            for (String line : string.split("\r\n")) {
                String[] lineParts = line.split(":");
                map.put(lineParts[0], lineParts[1]);
            }
            return map;
        }

        protected MapStdCSVDeserializer(Class<?> clazz) {
            super(clazz);
        }
    }

    public static abstract class CreatorMixin {
        @JsonProperty(access=JsonProperty.Access.READ_WRITE)
        public String externalReferenceCode;
        @JsonProperty(access=JsonProperty.Access.READ_WRITE)
        public Long id;
    }
}

