/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.exportimport.data.handler;

import com.liferay.batch.engine.constants.CreateStrategy;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import java.io.Serializable;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class BatchEnginePortletDataHandlerUtil {
    private static final Format _format = FastDateFormatFactoryUtil.getSimpleDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss'Z'");

    public static Map<String, Serializable> buildExportParameters(List<String> nestedFields, PortletDataContext portletDataContext) {
        return HashMapBuilder.put((Object)"batchNestedFields", () -> {
            ArrayList<String> batchNestedFields = new ArrayList<String>();
            if (MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"PERMISSIONS")) {
                batchNestedFields.add("permissions");
            }
            if (ListUtil.isNotEmpty((List)nestedFields)) {
                batchNestedFields.addAll(nestedFields);
            }
            if (batchNestedFields.isEmpty()) {
                return null;
            }
            return StringUtil.merge(batchNestedFields, (String)",");
        }).put((Object)"filter", () -> {
            if (portletDataContext.getEndDate() == null && portletDataContext.getStartDate() == null) {
                return null;
            }
            StringBundler sb = new StringBundler(5);
            if (portletDataContext.getEndDate() != null) {
                sb.append("dateModified le ");
                sb.append(_format.format(portletDataContext.getEndDate()));
            }
            if (portletDataContext.getStartDate() != null) {
                if (sb.length() > 0) {
                    sb.append(" and ");
                }
                sb.append("dateModified ge ");
                sb.append(_format.format(portletDataContext.getStartDate()));
            }
            return sb.toString();
        }).put((Object)"siteId", () -> {
            Map map = portletDataContext.getParameterMap();
            Object[] siteIds = GetterUtil.getStringValues((String[])((String[])map.get("siteId")));
            if (ArrayUtil.isNotEmpty((Object[])siteIds)) {
                return siteIds[0];
            }
            return Long.valueOf(portletDataContext.getScopeGroupId());
        }).build();
    }

    public static Map<String, Serializable> buildImportParameters(PortletDataContext portletDataContext) {
        return HashMapBuilder.put((Object)"batchRestrictFields", () -> {
            if (!MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"PERMISSIONS")) {
                return "permissions";
            }
            return null;
        }).put((Object)"createStrategy", (Object)CreateStrategy.UPSERT.getDBOperation()).put((Object)"importCreatorStrategy", () -> {
            if (!"CURRENT_USER_ID".equals(MapUtil.getString((Map)portletDataContext.getParameterMap(), (Object)"USER_ID_STRATEGY"))) {
                return null;
            }
            return "KEEP_CREATOR";
        }).put((Object)"siteId", (Object)portletDataContext.getScopeGroupId()).build();
    }
}

