/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.reader;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.liferay.batch.engine.internal.reader.BatchEngineImportTaskItemReader;
import com.liferay.batch.engine.internal.reader.FieldNameFilterFunction;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class JSONBatchEngineImportTaskItemReaderImpl
implements BatchEngineImportTaskItemReader {
    private static final JsonFactory _jsonFactory = new JsonFactory();
    private static final ObjectMapper _objectMapper = new ObjectMapper();
    private Function<Map<String, Object>, Map<String, Object>> _fieldNameFilter = m -> m;
    private final InputStream _inputStream;
    private final JsonParser _jsonParser;

    public JSONBatchEngineImportTaskItemReaderImpl(List<String> includeFieldNames, InputStream inputStream) throws IOException {
        if (!includeFieldNames.isEmpty()) {
            this._fieldNameFilter = new FieldNameFilterFunction(includeFieldNames);
        }
        this._inputStream = inputStream;
        this._jsonParser = _jsonFactory.createParser(this._inputStream);
        JsonToken jsonToken = this._jsonParser.nextToken();
        if (jsonToken != JsonToken.START_ARRAY) {
            throw new IllegalArgumentException("Provided stream is not a JSON array");
        }
    }

    @Override
    public void close() throws IOException {
        this._inputStream.close();
        this._jsonParser.close();
    }

    @Override
    public Map<String, Object> read() throws Exception {
        if (this._jsonParser.nextToken() != JsonToken.START_OBJECT) {
            return null;
        }
        return this._fieldNameFilter.apply((Map)_objectMapper.readValue(this._jsonParser, (TypeReference)new TypeReference<Map<String, Object>>(){}));
    }
}

