/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.writer;

import com.liferay.petra.concurrent.ConcurrentReferenceKeyHashMap;
import com.liferay.petra.concurrent.ConcurrentReferenceValueHashMap;
import com.liferay.petra.memory.FinalizeManager;
import com.liferay.portal.kernel.util.ObjectValuePair;
import com.liferay.portal.kernel.util.StringUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

public class ItemClassIndexUtil {
    private static final Map<Class<?>, Map<String, ObjectValuePair<Field, Method>>> _fieldNameObjectValuePairs = new ConcurrentReferenceKeyHashMap((ConcurrentMap)new ConcurrentReferenceValueHashMap(FinalizeManager.WEAK_REFERENCE_FACTORY), FinalizeManager.WEAK_REFERENCE_FACTORY);
    private static final List<Class<?>> _objectTypes = Arrays.asList(Boolean.class, BigDecimal.class, BigInteger.class, Byte.class, Date.class, Double.class, Float.class, Integer.class, Long.class, String.class);

    public static Map<String, ObjectValuePair<Field, Method>> index(Class<?> itemClass) {
        LinkedList queue = new LinkedList();
        Map fieldNameObjectValuePairs = _fieldNameObjectValuePairs.computeIfAbsent(itemClass, clazz -> ItemClassIndexUtil._index(clazz, queue));
        while ((itemClass = (Class)queue.poll()) != null) {
            _fieldNameObjectValuePairs.computeIfAbsent(itemClass, clazz -> ItemClassIndexUtil._index(clazz, queue));
        }
        return fieldNameObjectValuePairs;
    }

    public static boolean isDate(Class<?> clazz) {
        return Objects.equals(clazz, Date.class);
    }

    public static boolean isIterable(Class<?> valueClass) {
        return valueClass.isArray() || Collection.class.isAssignableFrom(valueClass);
    }

    public static boolean isMap(Class<?> clazz) {
        return Objects.equals(clazz, Map.class);
    }

    public static boolean isMultidimensionalArray(Class<?> clazz) {
        if (!clazz.isArray()) {
            return false;
        }
        Class<?> componentTypeClass = clazz.getComponentType();
        return componentTypeClass.isArray();
    }

    public static boolean isSingleColumnAdoptableArray(Class<?> clazz) {
        if (!clazz.isArray()) {
            return false;
        }
        return ItemClassIndexUtil.isSingleColumnAdoptableValue(clazz.getComponentType());
    }

    public static boolean isSingleColumnAdoptableValue(Class<?> clazz) {
        return clazz.isPrimitive() || _objectTypes.contains(clazz) || Enum.class.isAssignableFrom(clazz);
    }

    private static Method _getGetterMethod(Class<?> clazz, Field field, String name) {
        Class<?> fieldClass = field.getType();
        String methodName = null;
        methodName = fieldClass.isEnum() ? "get" + fieldClass.getSimpleName() : "get" + StringUtil.upperCaseFirstLetter((String)name);
        for (Method method : clazz.getMethods()) {
            if (!StringUtil.equals((String)method.getName(), (String)methodName) || method.getParameterCount() != 0 || !Objects.equals(fieldClass, method.getReturnType())) continue;
            return method;
        }
        return null;
    }

    private static Map<String, ObjectValuePair<Field, Method>> _index(Class<?> clazz, Queue<Class<?>> queue) {
        HashMap<String, ObjectValuePair<Field, Method>> fieldNameObjectValuePairs = new HashMap<String, ObjectValuePair<Field, Method>>();
        while (clazz != Object.class) {
            for (Field field : clazz.getDeclaredFields()) {
                if (ItemClassIndexUtil.isMultidimensionalArray(field.getType()) || Objects.equals(field.getType(), Supplier.class)) continue;
                field.setAccessible(true);
                String name = field.getName();
                if (name.charAt(0) == '_') {
                    name = name.substring(1);
                }
                if (field.isSynthetic()) continue;
                fieldNameObjectValuePairs.put(name, (ObjectValuePair<Field, Method>)new ObjectValuePair((Object)field, (Object)ItemClassIndexUtil._getGetterMethod(clazz, field, name)));
                Class<?> fieldClass = field.getType();
                if (ItemClassIndexUtil.isIterable(fieldClass) || ItemClassIndexUtil.isMap(fieldClass) || ItemClassIndexUtil.isSingleColumnAdoptableArray(fieldClass) || ItemClassIndexUtil.isSingleColumnAdoptableValue(fieldClass) || Objects.equals(clazz, fieldClass)) continue;
                queue.add(clazz);
            }
            if (Objects.equals(clazz.getSuperclass(), clazz.getDeclaringClass())) break;
            clazz = clazz.getSuperclass();
        }
        return fieldNameObjectValuePairs;
    }
}

