/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.reader;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.liferay.batch.engine.action.ItemReaderPostAction;
import com.liferay.batch.engine.model.BatchEngineImportTask;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BatchEngineImportTaskItemReaderUtil {
    private static final Log _log = LogFactoryUtil.getLog(BatchEngineImportTaskItemReaderUtil.class);
    private static final Pattern _multiselectPicklistPattern = Pattern.compile("key_\\d+|name_\\d+");
    private static final ObjectMapper _objectMapper = new ObjectMapper(){
        {
            SimpleModule simpleModule = new SimpleModule();
            simpleModule.addDeserializer(Map.class, (JsonDeserializer)new MapStdDeserializer());
            this.registerModule((Module)simpleModule);
        }
    };

    public static <T> T convertValue(BatchEngineImportTask batchEngineImportTask, Class<T> itemClass, Map<String, Object> fieldNameValueMap, List<ItemReaderPostAction> itemReaderPostActions) throws ReflectiveOperationException {
        HashMap<String, Serializable> extendedProperties = new HashMap<String, Serializable>();
        T item = itemClass.newInstance();
        boolean keepCreatorInfo = false;
        if (StringUtil.equals((String)batchEngineImportTask.getParameterValue("importCreatorStrategy"), (String)"KEEP_CREATOR")) {
            keepCreatorInfo = true;
        }
        Set<String> batchRestrictFields = BatchEngineImportTaskItemReaderUtil._getBatchRestrictFields(batchEngineImportTask);
        for (Map.Entry<String, Object> entry : fieldNameValueMap.entrySet()) {
            String name = entry.getKey();
            if (batchRestrictFields.contains(name)) continue;
            Field field = null;
            for (Field declaredField : itemClass.getDeclaredFields()) {
                if (!name.equals(declaredField.getName()) && !Objects.equals("_" + name, declaredField.getName())) continue;
                field = declaredField;
                break;
            }
            if (field != null) {
                field.setAccessible(true);
                ObjectMapper objectMapper = BatchEngineImportTaskItemReaderUtil._getObjectMapper(field, keepCreatorInfo);
                field.set(item, objectMapper.convertValue(entry.getValue(), field.getType()));
                continue;
            }
            for (Field declaredField : itemClass.getDeclaredFields()) {
                JsonAnySetter[] jsonAnySetters = (JsonAnySetter[])declaredField.getAnnotationsByType(JsonAnySetter.class);
                if (jsonAnySetters.length <= 0) continue;
                field = declaredField;
                break;
            }
            if (field == null) {
                extendedProperties.put(entry.getKey(), (Serializable)entry.getValue());
                continue;
            }
            field.setAccessible(true);
            Map map = (Map)field.get(item);
            map.put(entry.getKey(), entry.getValue());
        }
        for (ItemReaderPostAction itemReaderPostAction : itemReaderPostActions) {
            itemReaderPostAction.run(batchEngineImportTask, extendedProperties, item);
        }
        return item;
    }

    public static Map<String, Object> mapFieldNames(Map<String, ? extends Serializable> fieldNameMappingMap, Map<String, Object> fieldNameValueMap) {
        if (fieldNameMappingMap == null || fieldNameMappingMap.isEmpty()) {
            return fieldNameValueMap;
        }
        HashMap<String, Object> targetFieldNameValueMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : fieldNameValueMap.entrySet()) {
            String targetFieldName = (String)((Object)fieldNameMappingMap.get(entry.getKey()));
            if (Validator.isNotNull((String)targetFieldName)) {
                Object object = targetFieldNameValueMap.get(targetFieldName);
                if (object != null && object instanceof Map) {
                    Map map = (Map)object;
                    map.putAll((Map)entry.getValue());
                    continue;
                }
                targetFieldNameValueMap.put(targetFieldName, entry.getValue());
                continue;
            }
            String[] fieldNameParts = StringUtil.split((String)entry.getKey(), (String)".");
            targetFieldName = (String)((Object)fieldNameMappingMap.get(fieldNameParts[0]));
            if (Validator.isNull((String)targetFieldName)) continue;
            Matcher multiselectPicklistMatcher = _multiselectPicklistPattern.matcher(fieldNameParts[1]);
            if (multiselectPicklistMatcher.matches()) {
                if (fieldNameParts[1].startsWith("name_")) continue;
                List list = (List)targetFieldNameValueMap.computeIfAbsent(targetFieldName, key -> new ArrayList());
                list.add(entry.getValue());
                continue;
            }
            Map map = (Map)targetFieldNameValueMap.computeIfAbsent(targetFieldName, key -> new HashMap());
            for (int i = 1; i < fieldNameParts.length; ++i) {
                if (fieldNameParts.length - 1 > i) {
                    map = (Map)map.computeIfAbsent(fieldNameParts[i], key -> new HashMap());
                    continue;
                }
                map.put(fieldNameParts[i], entry.getValue());
            }
        }
        return targetFieldNameValueMap;
    }

    private static Set<String> _getBatchRestrictFields(BatchEngineImportTask batchEngineImportTask) {
        Map parameters = batchEngineImportTask.getParameters();
        if (parameters == null) {
            return new HashSet<String>();
        }
        String batchRestrictFields = MapUtil.getString((Map)parameters, (Object)"batchRestrictFields");
        if (Validator.isBlank((String)batchRestrictFields)) {
            return new HashSet<String>();
        }
        return SetUtil.fromArray((Object[])StringUtil.split((String)batchRestrictFields));
    }

    private static ObjectMapper _getObjectMapper(final Field field, boolean keepCreatorInfo) throws IllegalAccessException, InstantiationException {
        if (keepCreatorInfo && StringUtil.equals((String)field.getName(), (String)"creator")) {
            return new ObjectMapper(){
                {
                    this.addMixIn(field.getType(), CreatorMixin.class);
                    SimpleModule simpleModule = new SimpleModule();
                    simpleModule.addDeserializer(Map.class, (JsonDeserializer)new MapStdDeserializer());
                    this.registerModule((Module)simpleModule);
                }
            };
        }
        Object[] jsonDeserializes = (JsonDeserialize[])field.getAnnotationsByType(JsonDeserialize.class);
        if (ArrayUtil.isEmpty((Object[])jsonDeserializes)) {
            return _objectMapper;
        }
        Object jsonDeserialize = jsonDeserializes[0];
        return new ObjectMapper((JsonDeserialize)jsonDeserialize){
            final /* synthetic */ JsonDeserialize val$jsonDeserialize;
            {
                this.val$jsonDeserialize = jsonDeserialize;
                SimpleModule simpleModule = new SimpleModule();
                simpleModule.addDeserializer(field.getType(), (JsonDeserializer)this.val$jsonDeserialize.using().newInstance());
                this.registerModule((Module)simpleModule);
            }
        };
    }

    private static class MapStdDeserializer
    extends StdDeserializer<Map<String, Object>> {
        public MapStdDeserializer() {
            this(Map.class);
        }

        public Map<String, Object> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
            try {
                return (Map)deserializationContext.readValue(jsonParser, LinkedHashMap.class);
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Throwable)exception);
                }
                LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
                String string = jsonParser.getValueAsString();
                for (String line : string.split("\r\n")) {
                    String[] lineParts = line.split(":");
                    map.put(lineParts[0], lineParts[1]);
                }
                return map;
            }
        }

        protected MapStdDeserializer(Class<?> clazz) {
            super(clazz);
        }
    }

    public static abstract class CreatorMixin {
        @JsonProperty(access=JsonProperty.Access.READ_WRITE)
        public String externalReferenceCode;
        @JsonProperty(access=JsonProperty.Access.READ_WRITE)
        public Long id;
    }
}

