/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.batch.engine.internal.writer;

import com.liferay.petra.concurrent.ConcurrentReferenceKeyHashMap;
import com.liferay.petra.concurrent.ConcurrentReferenceValueHashMap;
import com.liferay.petra.memory.FinalizeManager;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;

public class ItemClassIndexUtil {
    private static final Map<Class<?>, Map<String, Field>> _fieldsMap = new ConcurrentReferenceKeyHashMap((ConcurrentMap)new ConcurrentReferenceValueHashMap(FinalizeManager.WEAK_REFERENCE_FACTORY), FinalizeManager.WEAK_REFERENCE_FACTORY);
    private static final List<Class<?>> _objectTypes = Arrays.asList(Boolean.class, BigDecimal.class, BigInteger.class, Byte.class, Date.class, Double.class, Float.class, Integer.class, Long.class, Map.class, String.class);

    public static Map<String, Field> index(Class<?> itemClass) {
        return _fieldsMap.computeIfAbsent(itemClass, clazz -> {
            HashMap<String, Field> fieldMap = new HashMap<String, Field>();
            while (clazz != Object.class) {
                for (Field field : clazz.getDeclaredFields()) {
                    Class<?> valueClass = field.getType();
                    if (!valueClass.isPrimitive() && !_objectTypes.contains(valueClass)) continue;
                    field.setAccessible(true);
                    String name = field.getName();
                    if (name.charAt(0) == '_') {
                        name = name.substring(1);
                    }
                    fieldMap.put(name, field);
                }
                clazz = clazz.getSuperclass();
            }
            return fieldMap;
        });
    }
}

