/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.app.builder.service.impl;

import com.liferay.app.builder.deploy.AppDeployer;
import com.liferay.app.builder.model.AppBuilderAppDeployment;
import com.liferay.app.builder.service.base.AppBuilderAppDeploymentLocalServiceBaseImpl;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import java.util.List;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(property={"model.class.name=com.liferay.app.builder.model.AppBuilderAppDeployment"}, service={AopService.class})
public class AppBuilderAppDeploymentLocalServiceImpl
extends AppBuilderAppDeploymentLocalServiceBaseImpl {
    private ServiceTrackerMap<String, AppDeployer> _serviceTrackerMap;

    public AppBuilderAppDeployment addAppBuilderAppDeployment(long appBuilderAppId, String settings, String type) {
        AppBuilderAppDeployment appBuilderAppDeployment = this.appBuilderAppDeploymentPersistence.create(this.counterLocalService.increment());
        appBuilderAppDeployment.setAppBuilderAppId(appBuilderAppId);
        appBuilderAppDeployment.setSettings(settings);
        appBuilderAppDeployment.setType(type);
        return (AppBuilderAppDeployment)this.appBuilderAppDeploymentPersistence.update((BaseModel)appBuilderAppDeployment);
    }

    @Override
    public AppBuilderAppDeployment deleteAppBuilderAppDeployment(long appBuilderAppDeploymentId) throws PortalException {
        AppBuilderAppDeployment appBuilderAppDeployment = this.getAppBuilderAppDeployment(appBuilderAppDeploymentId);
        AppDeployer appDeployer = (AppDeployer)this._serviceTrackerMap.getService((Object)appBuilderAppDeployment.getType());
        try {
            if (appDeployer != null) {
                appDeployer.undeploy(appBuilderAppDeployment.getAppBuilderAppId());
            }
        }
        catch (PortalException portalException) {
            throw portalException;
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
        return super.deleteAppBuilderAppDeployment(appBuilderAppDeploymentId);
    }

    public AppBuilderAppDeployment getAppBuilderAppDeployment(long appBuilderAppId, String type) throws PortalException {
        return this.appBuilderAppDeploymentPersistence.findByA_T(appBuilderAppId, type);
    }

    public List<AppBuilderAppDeployment> getAppBuilderAppDeployments(long appBuilderAppId) {
        return this.appBuilderAppDeploymentPersistence.findByAppBuilderAppId(appBuilderAppId);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, AppDeployer.class, (String)"app.builder.deploy.type");
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
        this._serviceTrackerMap.close();
    }
}

