/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.app.builder.internal.security.permission.resource;

import com.liferay.app.builder.model.AppBuilderApp;
import com.liferay.app.builder.service.AppBuilderAppLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.app.builder.model.AppBuilderApp"}, service={ModelResourcePermission.class})
public class AppBuilderAppModelResourcePermission
implements ModelResourcePermission<AppBuilderApp> {
    @Reference
    private AppBuilderAppLocalService _appBuilderAppLocalService;
    @Reference(target="(resource.name=com.liferay.app.builder)")
    private PortletResourcePermission _portletResourcePermission;

    public void check(PermissionChecker permissionChecker, AppBuilderApp appBuilderApp, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, appBuilderApp, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, AppBuilderApp.class.getName(), appBuilderApp.getPrimaryKey(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long appBuilderAppId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, appBuilderAppId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, AppBuilderApp.class.getName(), appBuilderAppId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, AppBuilderApp appBuilderApp, String actionId) throws PortalException {
        if (this._portletResourcePermission.contains(permissionChecker, appBuilderApp.getGroupId(), "MANAGE")) {
            return true;
        }
        return permissionChecker.hasPermission(null, AppBuilderApp.class.getName(), appBuilderApp.getPrimaryKey(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long appBuilderAppId, String actionId) throws PortalException {
        return this.contains(permissionChecker, this._appBuilderAppLocalService.getAppBuilderApp(appBuilderAppId), actionId);
    }

    public String getModelName() {
        return AppBuilderApp.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return this._portletResourcePermission;
    }
}

