/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.analytics.cms.rest.internal.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.liferay.analytics.cms.rest.dto.v1_0.ObjectEntryMetric;
import com.liferay.analytics.settings.configuration.AnalyticsConfiguration;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AnalyticsCloudClient {
    private static final Log _log = LogFactoryUtil.getLog(AnalyticsCloudClient.class);
    private final Http _http;

    public AnalyticsCloudClient(Http http) {
        this._http = http;
    }

    public ObjectEntryMetric getObjectEntryMetric(AnalyticsConfiguration analyticsConfiguration, String externalReferenceCode, Long groupId, Integer rangeKey, String[] selectedMetrics) throws Exception {
        try {
            Http.Options options = this._getOptions(analyticsConfiguration);
            ArrayList<Long> groupIds = new ArrayList<Long>();
            if (groupId != null) {
                groupIds.add(groupId);
            }
            options.setLocation(this._getUrl(analyticsConfiguration.liferayAnalyticsDataSourceId(), externalReferenceCode, groupIds, analyticsConfiguration.liferayAnalyticsFaroBackendURL(), "/overview", rangeKey, selectedMetrics));
            String content = this._http.URLtoString(options);
            Http.Response response = options.getResponse();
            if (response.getResponseCode() == 200) {
                ObjectEntryMetric objectEntryMetric = null;
                JsonNode jsonNode = ObjectMapperHolder._objectMapper.readTree(content);
                if (jsonNode != null) {
                    this._renameKey(jsonNode, "classification", "trendClassification");
                    TypeFactory typeFactory = TypeFactory.defaultInstance();
                    ObjectReader objectReader = ObjectMapperHolder._objectMapper.readerFor(typeFactory.constructType(ObjectEntryMetric.class));
                    objectEntryMetric = (ObjectEntryMetric)objectReader.readValue(jsonNode);
                }
                return objectEntryMetric;
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Response code " + response.getResponseCode()));
            }
            throw new PortalException("Unable to get object entry metric");
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            throw new PortalException("Unable to get object entry metric", (Throwable)exception);
        }
    }

    private Http.Options _getOptions(AnalyticsConfiguration analyticsConfiguration) throws Exception {
        Http.Options options = new Http.Options();
        options.addHeader("OSB-Asah-Faro-Backend-Security-Signature", analyticsConfiguration.liferayAnalyticsFaroBackendSecuritySignature());
        options.addHeader("OSB-Asah-Project-ID", analyticsConfiguration.liferayAnalyticsProjectId());
        return options;
    }

    private String _getUrl(String dataSourceId, String externalReferenceCode, List<Long> groupIds, String liferayAnalyticsFaroBackendURL, String path, Integer rangeKey, String[] selectedMetrics) {
        String url = String.join((CharSequence)"", liferayAnalyticsFaroBackendURL, "/api/1.0/asset-metric/objectEntry", path);
        url = HttpComponentsUtil.addParameter((String)url, (String)"dataSourceId", (String)dataSourceId);
        url = HttpComponentsUtil.addParameter((String)url, (String)"externalReferenceCode", (String)externalReferenceCode);
        if (!groupIds.isEmpty()) {
            url = HttpComponentsUtil.addParameter((String)url, (String)"groupIds", (String)StringUtil.merge(groupIds, (String)","));
        }
        if (rangeKey != null) {
            url = HttpComponentsUtil.addParameter((String)url, (String)"rangeKey", (int)rangeKey);
        }
        return HttpComponentsUtil.addParameter((String)url, (String)"selectedMetrics", (String)StringUtil.merge((Object[])selectedMetrics, (String)","));
    }

    private void _renameKey(JsonNode jsonNode, String newKey, String oldKey) {
        if (jsonNode == null) {
            return;
        }
        if (jsonNode.isObject()) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            if (objectNode.has(oldKey)) {
                JsonNode objectJsonNode = objectNode.remove(oldKey);
                objectNode.set(newKey, objectJsonNode);
            }
            Iterator iterator = objectNode.fields();
            iterator.forEachRemaining(entry -> this._renameKey((JsonNode)entry.getValue(), newKey, oldKey));
        } else if (jsonNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            for (JsonNode arrayJsonNode : arrayNode) {
                this._renameKey(arrayJsonNode, newKey, oldKey);
            }
        }
    }

    private static class ObjectMapperHolder {
        private static final ObjectMapper _objectMapper = new ObjectMapper(){
            {
                this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
                this.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
            }
        };

        private ObjectMapperHolder() {
        }
    }
}

