/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ai.hub.site.initializer.internal.mcp.tool.provider;

import com.liferay.ai.hub.site.initializer.mcp.tool.provider.MCPToolProviderFactory;
import com.liferay.object.rest.dto.v1_0.ObjectEntry;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import com.liferay.portal.vulcan.pagination.Page;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.mcp.McpToolProvider;
import dev.langchain4j.mcp.client.DefaultMcpClient;
import dev.langchain4j.mcp.client.transport.McpTransport;
import dev.langchain4j.mcp.client.transport.http.HttpMcpTransport;
import dev.langchain4j.mcp.client.transport.http.StreamableHttpMcpTransport;
import dev.langchain4j.model.chat.request.json.JsonAnyOfSchema;
import dev.langchain4j.model.chat.request.json.JsonObjectSchema;
import dev.langchain4j.model.chat.request.json.JsonSchemaElement;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={MCPToolProviderFactory.class})
public class MCPToolProviderFactoryImpl
implements MCPToolProviderFactory {
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference(target="(object.entry.manager.storage.type=default)")
    private ObjectEntryManager _objectEntryManager;
    @Reference
    private UserService _userService;

    public McpToolProvider create(long companyId, long groupId, Locale locale, List<String> mcpServerExternalReferenceCodes, long userId) {
        if (ListUtil.isEmpty(mcpServerExternalReferenceCodes)) {
            return null;
        }
        return McpToolProvider.builder().mcpClients(TransformUtil.transform(this._getMCPServerObjectEntries(companyId, groupId, locale, mcpServerExternalReferenceCodes, userId), objectEntry -> {
            McpTransport mcpTransport = this._createMcpTransport(objectEntry.getProperties());
            return new DefaultMcpClient.Builder().transport(mcpTransport).build();
        })).filter((mcpClient, toolSpecification) -> this._filterToolSpecifications((ToolSpecification)toolSpecification)).build();
    }

    private Map<String, String> _createCustomHeaders(String authArguments) {
        if (authArguments.isBlank()) {
            return Map.of();
        }
        return Map.of("Authorization", this._parseBasicAuthorization(authArguments));
    }

    private McpTransport _createMcpTransport(Map<String, Object> properties) {
        String url = GetterUtil.getString((Object)properties.get("url"));
        Map<String, String> customHeaders = this._createCustomHeaders(GetterUtil.getString((Object)properties.get("authenticationArguments")));
        if (url.endsWith("/sse")) {
            return new HttpMcpTransport.Builder().customHeaders(customHeaders).sseUrl(url).build();
        }
        return new StreamableHttpMcpTransport.Builder().customHeaders(customHeaders).url(url).build();
    }

    private boolean _filterToolSpecifications(ToolSpecification toolSpecification) {
        JsonObjectSchema jsonObjectSchema = toolSpecification.parameters();
        Map properties = jsonObjectSchema.properties();
        for (JsonSchemaElement jsonSchemaElement : properties.values()) {
            if (!(jsonSchemaElement instanceof JsonAnyOfSchema)) continue;
            return false;
        }
        return true;
    }

    private List<ObjectEntry> _getMCPServerObjectEntries(long companyId, long groupId, Locale locale, List<String> mcpServerExternalReferenceCodes, long userId) {
        try {
            Group group = this._groupLocalService.fetchGroup(groupId);
            Page page = this._objectEntryManager.getObjectEntries(companyId, this._objectDefinitionLocalService.fetchObjectDefinitionByExternalReferenceCode("L_MCP_SERVER", companyId), group.getGroupKey(), null, (DTOConverterContext)new DefaultDTOConverterContext(false, Map.of(), this._dtoConverterRegistry, null, locale, null, this._userService.getUserById(userId)), StringBundler.concat((String[])new String[]{"externalReferenceCode in (", StringUtil.merge((Collection)TransformUtil.transform(mcpServerExternalReferenceCodes, StringUtil::quote), (String)", "), ")"}), null, null, null);
            return (List)page.getItems();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private String _parseBasicAuthorization(String authArguments) {
        try {
            JSONObject jsonObject = this._jsonFactory.createJSONObject(authArguments);
            Base64.Encoder encoder = Base64.getEncoder();
            String credentials = jsonObject.getString("userName") + jsonObject.getString("password");
            return "Basic " + new String(encoder.encode(credentials.getBytes("UTF-8")), "UTF-8");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }
}

