/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ai.hub.site.initializer.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.workflow.manager.WorkflowDefinitionManager;
import com.liferay.site.exception.InitializationException;
import com.liferay.site.initializer.SiteInitializer;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"site.initializer.key=ai-hub-initializer"}, service={SiteInitializer.class})
public class AIHubSiteInitializer
implements SiteInitializer {
    public static final String KEY = "ai-hub-initializer";
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Language _language;
    @Reference
    private Localization _localization;
    @Reference
    private WorkflowDefinitionManager _workflowDefinitionManager;

    public String getDescription(Locale locale) {
        return "";
    }

    public String getKey() {
        return KEY;
    }

    public String getName(Locale locale) {
        return this._language.get(locale, "ai-hub");
    }

    public String getThumbnailSrc() {
        return "";
    }

    public void initialize(long groupId) throws InitializationException {
        try {
            this._initialize(groupId);
        }
        catch (InitializationException initializationException) {
            throw initializationException;
        }
        catch (Exception exception) {
            throw new InitializationException((Throwable)exception);
        }
    }

    public boolean isActive(long companyId) {
        return FeatureFlagManagerUtil.isEnabled((long)companyId, (String)"LPD-62272");
    }

    private void _deployWorkflowDefinition(Company company, String externalReferenceCode, String workflowDefinitionName, String workflowNodeName, String workflowNodeSettingPrompt, String workflowNodeSettingUserMessage) throws Exception {
        int count = this._workflowDefinitionManager.getWorkflowDefinitionsCount(company.getCompanyId(), workflowDefinitionName);
        if (count > 0) {
            return;
        }
        HashMap<String, String> titleMap = new HashMap<String, String>();
        for (Locale locale : this._language.getCompanyAvailableLocales(company.getCompanyId())) {
            titleMap.put(this._language.getLanguageId(locale), this._language.get(locale, workflowDefinitionName));
        }
        String json = StringUtil.replace((String)StringUtil.read((InputStream)AIHubSiteInitializer.class.getResourceAsStream("dependencies/workflow-definition.json.tpl")), (String[])new String[]{"[$WORKFLOW_DEFINITION_NAME$]", "[$WORKFLOW_NODE_NAME$]", "[$WORKFLOW_NODE_SETTING_PROMPT$]", "[$WORKFLOW_NODE_SETTING_USER_MESSAGE$]"}, (String[])new String[]{workflowDefinitionName, workflowNodeName, workflowNodeSettingPrompt, workflowNodeSettingUserMessage});
        this._workflowDefinitionManager.deployWorkflowDefinition(externalReferenceCode, company.getCompanyId(), PrincipalThreadLocal.getUserId(), this._localization.getXml(titleMap, this._language.getLanguageId(company.getLocale()), "title"), workflowDefinitionName, json.getBytes());
    }

    private void _initialize(long groupId) throws Exception {
        Group group = this._groupLocalService.getGroup(groupId);
        Company company = this._companyLocalService.getCompany(group.getCompanyId());
        this._deployWorkflowDefinition(company, "L_CHANGE_TONE", "Change Tone", "changeTone", StringBundler.concat((String[])new String[]{"You are an expert linguistic editor. Your sole task is to ", "adjust the tone of the provided text to be more {{tone}}. ", "Modify vocabulary, phrasing, and sentence structure as ", "needed while preserving the original meaning, intent, and ", "clarity. If the text already matches this tone, return it ", "unchanged. Output only the rewritten text, with no ", "explanations or commentary."}), "This is the text whose tone was changed to be {{tone}}: {{text}}");
        this._deployWorkflowDefinition(company, "L_FIX_SPELLING_AND_GRAMMAR", "Fix Spelling and Grammar", "fixSpellingAndGrammar", StringBundler.concat((String[])new String[]{"You are an expert linguistic editor. Your sole task is to ", "correct all grammatical, spelling, and punctuation errors in ", "the provided text while preserving its meaning, tone, and ", "style. Do not alter structure or wording beyond what is ", "necessary for grammatical precision and natural fluency. ", "Output only the corrected text, with no explanations or ", "commentary. If the text is already correct, return it ", "unchanged."}), "This is the text to be fixed: {{text}}");
        this._deployWorkflowDefinition(company, "L_IMPROVE_WRITING", "Improve Writing", "improveWriting", StringBundler.concat((String[])new String[]{"You are a professional writing editor. Your sole task is to ", "take the provided text and rewrite it to be significantly ", "more concise, direct, and free of unnecessary filler words, ", "nominalizations, and passive voice, while retaining the ", "original meaning and professional tone. Only output the ", "revised, concise text. Do not include any explanation, ", "introduction, or conversation."}), "This is the text to be rewritten: {{text}}");
        this._deployWorkflowDefinition(company, "L_MAKE_LONGER", "Make Longer", "makeLonger", StringBundler.concat((String[])new String[]{"You are an expert linguistic enhancer. Expand the provided ", "text by adding relevant and natural details that clarify or ", "enrich its meaning. Keep the original tone, intent, and ", "structure. Avoid unnecessary embellishment, repetition, or ", "creative exaggeration. Output only the expanded text."}), "This is the text to be detailed: {{text}}");
        this._deployWorkflowDefinition(company, "L_MAKE_SHORTER", "Make Shorter", "makeShorter", StringBundler.concat((String[])new String[]{"You are an expert linguistic editor. Your sole task is to ", "reduce the length of the provided text while preserving all ", "essential information, key points, and original intent. ", "Remove redundancy, filler, and unnecessary detail without ", "changing meaning, tone, or clarity. If the text is already ", "concise and cannot be shortened without losing important ", "content, return it unchanged. Output only the shortened ", "text, with no explanations or commentary."}), "This is the text to be shortened: {{text}}");
    }
}

