/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ai.hub.site.initializer.internal;

import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.workflow.manager.WorkflowDefinitionManager;
import com.liferay.site.exception.InitializationException;
import com.liferay.site.initializer.SiteInitializer;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"site.initializer.key=ai-hub-initializer"}, service={SiteInitializer.class})
public class AIHubSiteInitializer
implements SiteInitializer {
    public static final String KEY = "ai-hub-initializer";
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Language _language;
    @Reference
    private Localization _localization;
    @Reference
    private WorkflowDefinitionManager _workflowDefinitionManager;

    public String getDescription(Locale locale) {
        return "";
    }

    public String getKey() {
        return KEY;
    }

    public String getName(Locale locale) {
        return this._language.get(locale, "ai-hub");
    }

    public String getThumbnailSrc() {
        return "";
    }

    public void initialize(long groupId) throws InitializationException {
        try {
            this._initialize(groupId);
        }
        catch (InitializationException initializationException) {
            throw initializationException;
        }
        catch (Exception exception) {
            throw new InitializationException((Throwable)exception);
        }
    }

    public boolean isActive(long companyId) {
        return FeatureFlagManagerUtil.isEnabled((long)companyId, (String)"LPD-62272");
    }

    private void _initialize(long groupId) throws Exception {
        Group group = this._groupLocalService.getGroup(groupId);
        int count = this._workflowDefinitionManager.getWorkflowDefinitionsCount(group.getCompanyId(), "Improve Writing");
        if (count > 0) {
            return;
        }
        Company company = this._companyLocalService.getCompany(group.getCompanyId());
        HashMap<String, String> titleMap = new HashMap<String, String>();
        for (Locale locale : this._language.getCompanyAvailableLocales(company.getCompanyId())) {
            titleMap.put(this._language.getLanguageId(locale), this._language.get(locale, "Improve Writing"));
        }
        String json = StringUtil.read((InputStream)AIHubSiteInitializer.class.getResourceAsStream("dependencies/improve-writing-workflow-definition.json"));
        this._workflowDefinitionManager.deployWorkflowDefinition("L_IMPROVE_WRITING", company.getCompanyId(), PrincipalThreadLocal.getUserId(), this._localization.getXml(titleMap, this._language.getLanguageId(company.getLocale()), "title"), "Improve Writing", json.getBytes());
    }
}

