/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ai.hub.rest.resource.v1_0.util;

import com.liferay.portal.kernel.util.PortalRunMode;
import jakarta.ws.rs.sse.Sse;
import jakarta.ws.rs.sse.SseBroadcaster;
import jakarta.ws.rs.sse.SseEventSink;

public class SseUtil {
    private static SseBroadcaster _sseBroadcaster;

    public static void broadcast(String data, String id, String name, Sse sse) {
        if (_sseBroadcaster == null) {
            return;
        }
        try {
            _sseBroadcaster.broadcast(sse.newEventBuilder().data(String.class, (Object)data).id(id).name(name).build());
        }
        catch (Exception exception) {
            _sseBroadcaster.close();
            throw exception;
        }
    }

    public static void close() {
        if (_sseBroadcaster == null || !PortalRunMode.isTestMode()) {
            return;
        }
        _sseBroadcaster.close();
        _sseBroadcaster = null;
    }

    public static void initialize(Sse sse, SseEventSink sseEventSink) {
        SseBroadcaster sseBroadcaster = SseUtil._getSseBroadcaster(sse);
        sseBroadcaster.register(sseEventSink);
        sseBroadcaster.broadcast(sse.newEventBuilder().name("Subscribe").data(String.class, (Object)"Successfully Subscribed").build());
    }

    private static SseBroadcaster _getSseBroadcaster(Sse sse) {
        if (_sseBroadcaster != null) {
            return _sseBroadcaster;
        }
        _sseBroadcaster = sse.newBroadcaster();
        return _sseBroadcaster;
    }
}

