/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ai.hub.internal.workflow.kaleo.runtime.node.util;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class VariablesUtil {
    private static final Log _log = LogFactoryUtil.getLog(VariablesUtil.class);

    public static String applyInputVariables(ExecutionContext executionContext, String kaleoNodeSettingName, Map<String, String> kaleoNodeSettingValues) {
        Map<String, String> inputVariables = VariablesUtil._getInputVariables(kaleoNodeSettingValues, executionContext.getWorkflowContext());
        String value = kaleoNodeSettingValues.get(kaleoNodeSettingName);
        for (Map.Entry<String, String> entry : inputVariables.entrySet()) {
            value = StringUtil.replace((String)value, (String)("{{" + entry.getKey() + "}}"), (String)entry.getValue());
        }
        return value;
    }

    public static JSONArray getVariablesJSONArray(String kaleoNodeSettingName, Map<String, String> kaleoNodeSettingValues) {
        String variables = kaleoNodeSettingValues.get(kaleoNodeSettingName);
        if (variables == null) {
            return null;
        }
        try {
            return JSONFactoryUtil.createJSONArray((String)variables);
        }
        catch (JSONException jsonException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)jsonException);
            }
            return null;
        }
    }

    private static Map<String, String> _getInputVariables(Map<String, String> kaleoNodeSettingValues, Map<String, Serializable> workflowContext) {
        JSONArray jsonArray = VariablesUtil.getVariablesJSONArray("inputVariables", kaleoNodeSettingValues);
        if (jsonArray == null) {
            return Map.of();
        }
        HashMap<String, String> inputVariables = new HashMap<String, String>();
        Iterator iterator = jsonArray.iterator();
        iterator.forEachRemaining(jsonObject -> {
            String name = jsonObject.getString("name");
            inputVariables.put(name, GetterUtil.getString(workflowContext.get(name)));
        });
        return inputVariables;
    }
}

