/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ai.hub.internal.web.search;

import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.model.OAuth2Authorization;
import com.liferay.oauth2.provider.service.OAuth2ApplicationLocalServiceUtil;
import com.liferay.oauth2.provider.service.OAuth2AuthorizationLocalServiceUtil;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.rest.dto.v1_0.SearchResult;
import dev.langchain4j.web.search.WebSearchEngine;
import dev.langchain4j.web.search.WebSearchInformationResult;
import dev.langchain4j.web.search.WebSearchOrganicResult;
import dev.langchain4j.web.search.WebSearchRequest;
import dev.langchain4j.web.search.WebSearchResults;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;

public class LiferayWebSearchEngine
implements WebSearchEngine {
    private static final Log _log = LogFactoryUtil.getLog(LiferayWebSearchEngine.class);
    private final String _accessToken;
    private final String _blueprintExternalReferenceCode;
    private final String _userToken;

    public LiferayWebSearchEngine(String accessToken, String blueprintExternalReferenceCode, String userToken) {
        this._accessToken = accessToken;
        this._blueprintExternalReferenceCode = blueprintExternalReferenceCode;
        this._userToken = userToken;
    }

    public WebSearchResults search(WebSearchRequest webSearchRequest) {
        try {
            return this._search(webSearchRequest);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
            return (WebSearchResults)ReflectionUtil.throwException((Throwable)exception);
        }
    }

    private WebSearchResults _search(WebSearchRequest webSearchRequest) throws Exception {
        ArrayList<WebSearchOrganicResult> webSearchOrganicResults = new ArrayList<WebSearchOrganicResult>();
        Http.Options options = new Http.Options();
        options.addHeader("Content-Type", "application/json");
        options.addHeader("Liferay-AI-Hub-On-Behalf-Of", this._userToken);
        OAuth2Authorization oAuth2Authorization = OAuth2AuthorizationLocalServiceUtil.getOAuth2AuthorizationByAccessTokenContent((String)this._accessToken.substring(7));
        OAuth2Application oAuth2Application = OAuth2ApplicationLocalServiceUtil.getOAuth2Application((long)oAuth2Authorization.getOAuth2ApplicationId());
        Object location = oAuth2Application.getHomePageURL() + "/o/search/v1.0/search";
        if (!Validator.isBlank((String)this._blueprintExternalReferenceCode)) {
            location = HttpComponentsUtil.addParameter((String)location, (String)"blueprintExternalReferenceCode", (String)this._blueprintExternalReferenceCode);
        }
        location = HttpComponentsUtil.addParameter((String)location, (String)"page", (int)webSearchRequest.startPage());
        location = HttpComponentsUtil.addParameter((String)location, (String)"pageSize", (int)webSearchRequest.maxResults());
        location = HttpComponentsUtil.addParameter((String)location, (String)"search", (String)webSearchRequest.searchTerms());
        options.setLocation((String)location);
        options.setMethod(Http.Method.GET);
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)HttpUtil.URLtoString((Http.Options)options));
        for (JSONObject itemJSONObject : jsonObject.getJSONArray("items")) {
            SearchResult searchResult = SearchResult.toDTO((String)itemJSONObject.toString());
            float score = searchResult.getScore().floatValue();
            if (score < 5.0f) continue;
            String url = "";
            if (searchResult.getItemURL() != null) {
                url = searchResult.getItemURL();
            }
            webSearchOrganicResults.add(WebSearchOrganicResult.from((String)searchResult.getTitle(), (URI)URI.create(URLEncoder.encode(url, "UTF-8")), null, (String)searchResult.getDescription(), Map.of("score", String.valueOf(score))));
        }
        return WebSearchResults.from((WebSearchInformationResult)WebSearchInformationResult.from((Long)jsonObject.getLong("totalCount")), webSearchOrganicResults);
    }
}

