/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ai.hub.internal.security.service.access.policy;

import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.security.service.access.policy.model.SAPEntry;
import com.liferay.portal.security.service.access.policy.service.SAPEntryLocalService;
import java.util.Collections;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortalInstanceLifecycleListener.class})
public class AIHubSAPEntryPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    private static final String _SAP_ENTRY_NAME = "AI_HUB_TOKEN";
    private static final Log _log = LogFactoryUtil.getLog(AIHubSAPEntryPortalInstanceLifecycleListener.class);
    @Reference
    private SAPEntryLocalService _sapEntryLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void portalInstanceRegistered(Company company) throws Exception {
        if (!FeatureFlagManagerUtil.isEnabled((long)company.getCompanyId(), (String)"LPD-62272")) {
            return;
        }
        try {
            SAPEntry sapEntry = this._sapEntryLocalService.fetchSAPEntry(company.getCompanyId(), _SAP_ENTRY_NAME);
            if (sapEntry != null) {
                return;
            }
            this._sapEntryLocalService.addSAPEntry(this._userLocalService.getGuestUserId(company.getCompanyId()), "com.liferay.portal.search.rest.internal.resource.v1_0.SearchResultResourceImpl#getSearchPage", false, true, _SAP_ENTRY_NAME, Collections.singletonMap(LocaleUtil.getDefault(), _SAP_ENTRY_NAME), new ServiceContext());
        }
        catch (PortalException portalException) {
            _log.error((Object)("Unable to add service access policy entry for company " + company.getCompanyId()), (Throwable)portalException);
        }
    }
}

