/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ai.hub.internal.security.auth.verifier;

import com.liferay.ai.hub.security.JWTTokenUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.AccessControlContext;
import com.liferay.portal.kernel.security.auth.AuthException;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifier;
import com.liferay.portal.kernel.security.auth.verifier.AuthVerifierResult;
import com.liferay.portal.kernel.security.service.access.policy.ServiceAccessPolicy;
import com.liferay.portal.kernel.util.Validator;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.osgi.service.component.annotations.Component;

@Component(property={"auth.verifier.AIHubRequestAuthVerifier.urls.includes=*"}, service={AuthVerifier.class})
public class AIHubRequestAuthVerifier
implements AuthVerifier {
    private static final Log _log = LogFactoryUtil.getLog(AIHubRequestAuthVerifier.class);

    public String getAuthType() {
        Class<?> clazz = this.getClass();
        return clazz.getSimpleName();
    }

    public AuthVerifierResult verify(AccessControlContext accessControlContext, Properties properties) throws AuthException {
        try {
            HttpServletRequest httpServletRequest = accessControlContext.getRequest();
            String token = httpServletRequest.getHeader("Liferay-AI-Hub-On-Behalf-Of");
            if (Validator.isBlank((String)token)) {
                return new AuthVerifierResult();
            }
            long userId = JWTTokenUtil.getUserId((String)token);
            if (userId == 0L) {
                AuthVerifierResult authVerifierResult = new AuthVerifierResult();
                authVerifierResult.setState(AuthVerifierResult.State.INVALID_CREDENTIALS);
                return authVerifierResult;
            }
            AuthVerifierResult authVerifierResult = new AuthVerifierResult();
            Map settings = authVerifierResult.getSettings();
            List serviceAccessPolicyNames = (List)settings.computeIfAbsent(ServiceAccessPolicy.SERVICE_ACCESS_POLICY_NAMES, value -> new ArrayList());
            serviceAccessPolicyNames.add("AI_HUB_TOKEN");
            authVerifierResult.setState(AuthVerifierResult.State.SUCCESS);
            authVerifierResult.setUserId(userId);
            return authVerifierResult;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to verify AI Hub JWT token", (Throwable)exception);
            }
            return new AuthVerifierResult();
        }
    }
}

