/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ai.hub.internal.messaging;

import com.liferay.ai.hub.internal.agent.util.AgentUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.util.MapUtil;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"destination.name=liferay/workflow_instance"}, service={MessageListener.class})
public class WorkflowInstanceMessageListener
extends BaseMessageListener {
    @Reference
    private DestinationFactory _destinationFactory;
    private ServiceRegistration<Destination> _destinationServiceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext) {
        Destination destination = this._destinationFactory.createDestination(new DestinationConfiguration("parallel", "liferay/workflow_instance"));
        this._destinationServiceRegistration = bundleContext.registerService(Destination.class, (Object)destination, MapUtil.singletonDictionary((Object)"destination.name", (Object)destination.getName()));
    }

    @Deactivate
    protected void deactivate() {
        this._destinationServiceRegistration.unregister();
    }

    protected void doReceive(Message message) throws Exception {
        AgentUtil.complete((Map)message.get("workflowContext"), message.getLong("workflowInstanceId"));
    }
}

