/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ai.hub.internal.assistant.handler;

import dev.langchain4j.invocation.InvocationParameters;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.vertexai.gemini.VertexAiGeminiStreamingChatModel;
import dev.langchain4j.rag.content.retriever.ContentRetriever;
import dev.langchain4j.service.tool.ToolProvider;
import java.util.function.Consumer;
import java.util.function.Function;

public class AssistantHandlerContext {
    private final ContentRetriever _contentRetriever;
    private final InvocationParameters _invocationParameters;
    private final String _memoryId;
    private final Consumer<ChatResponse> _onCompleteResponse;
    private final Consumer<Throwable> _onError;
    private final Function<Object, String> _systemMessageProvider;
    private final ToolProvider _toolProvider;
    private final Object[] _tools;
    private final String _userMessage;
    private final VertexAiGeminiStreamingChatModel _vertexAiGeminiStreamingChatModel;

    public static Builder builder() {
        return new Builder();
    }

    public AssistantHandlerContext(Builder builder) {
        this._contentRetriever = builder._contentRetriever;
        this._invocationParameters = builder._invocationParameters;
        this._memoryId = builder._memoryId;
        this._onCompleteResponse = builder._onCompleteResponse;
        this._onError = builder._onError;
        this._systemMessageProvider = builder._systemMessageProvider;
        this._tools = builder._tools;
        this._toolProvider = builder._toolProvider;
        this._userMessage = builder._userMessage;
        this._vertexAiGeminiStreamingChatModel = builder._vertexAiGeminiStreamingChatModel;
    }

    public ContentRetriever getContentRetriever() {
        return this._contentRetriever;
    }

    public InvocationParameters getInvocationParameters() {
        return this._invocationParameters;
    }

    public String getMemoryId() {
        return this._memoryId;
    }

    public Consumer<ChatResponse> getOnCompleteResponse() {
        return this._onCompleteResponse;
    }

    public Consumer<Throwable> getOnError() {
        return this._onError;
    }

    public Function<Object, String> getSystemMessageProvider() {
        return this._systemMessageProvider;
    }

    public ToolProvider getToolProvider() {
        return this._toolProvider;
    }

    public Object[] getTools() {
        return this._tools;
    }

    public String getUserMessage() {
        return this._userMessage;
    }

    public VertexAiGeminiStreamingChatModel getVertexAiGeminiStreamingChatModel() {
        return this._vertexAiGeminiStreamingChatModel;
    }

    public static class Builder {
        private ContentRetriever _contentRetriever;
        private InvocationParameters _invocationParameters;
        private String _memoryId;
        private Consumer<ChatResponse> _onCompleteResponse;
        private Consumer<Throwable> _onError;
        private Function<Object, String> _systemMessageProvider;
        private ToolProvider _toolProvider;
        private Object[] _tools = new Object[0];
        private String _userMessage;
        private VertexAiGeminiStreamingChatModel _vertexAiGeminiStreamingChatModel;

        public AssistantHandlerContext build() {
            return new AssistantHandlerContext(this);
        }

        public Builder contentRetriever(ContentRetriever contentRetriever) {
            this._contentRetriever = contentRetriever;
            return this;
        }

        public Builder invocationParameters(InvocationParameters invocationParameters) {
            this._invocationParameters = invocationParameters;
            return this;
        }

        public Builder memoryId(String memoryId) {
            this._memoryId = memoryId;
            return this;
        }

        public Builder onCompleteResponse(Consumer<ChatResponse> onCompleteResponse) {
            this._onCompleteResponse = onCompleteResponse;
            return this;
        }

        public Builder onError(Consumer<Throwable> onError) {
            this._onError = onError;
            return this;
        }

        public Builder systemMessageProvider(Function<Object, String> systemMessageProvider) {
            this._systemMessageProvider = systemMessageProvider;
            return this;
        }

        public Builder toolProvider(ToolProvider toolProvider) {
            if (toolProvider != null) {
                this._toolProvider = toolProvider;
            }
            return this;
        }

        public Builder tools(Object ... tools) {
            this._tools = tools;
            return this;
        }

        public Builder userMessage(String userMessage) {
            this._userMessage = userMessage;
            return this;
        }

        public Builder vertexAiGeminiStreamingChatModel(VertexAiGeminiStreamingChatModel vertexAiGeminiStreamingChatModel) {
            this._vertexAiGeminiStreamingChatModel = vertexAiGeminiStreamingChatModel;
            return this;
        }
    }
}

