/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ai.hub.internal.agent;

import com.liferay.ai.hub.agent.AgentContext;
import com.liferay.ai.hub.agent.AgentsFactory;
import com.liferay.ai.hub.agent.SupervisorAgent;
import com.liferay.ai.hub.rest.resource.v1_0.util.SseUtil;
import com.liferay.petra.concurrent.NoticeableExecutorService;
import com.liferay.petra.executor.PortalExecutorManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.CompanyInheritableThreadLocalCallable;
import com.liferay.portal.kernel.util.MapUtil;
import dev.langchain4j.agentic.AgenticServices;
import dev.langchain4j.agentic.supervisor.SupervisorResponseStrategy;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.model.vertexai.gemini.VertexAiGeminiChatModel;
import java.util.Map;
import java.util.concurrent.Callable;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={SupervisorAgent.class})
public class SupervisorAgentImpl
implements SupervisorAgent {
    private static final Log _log = LogFactoryUtil.getLog(SupervisorAgentImpl.class);
    @Reference
    private AgentsFactory _agentsFactory;
    private NoticeableExecutorService _noticeableExecutorService;
    @Reference
    private PortalExecutorManager _portalExecutorManager;

    public void invoke(AgentContext agentContext) {
        Object[] agents = this._agentsFactory.create(agentContext);
        this._noticeableExecutorService.submit((Callable)new CompanyInheritableThreadLocalCallable(() -> {
            try (VertexAiGeminiChatModel vertexAiGeminiChatModel = VertexAiGeminiChatModel.builder().location("us-central1").modelName("gemini-2.5-flash-lite").project("ai-hub-liferay").build();){
                this._invoke(agentContext, agents, vertexAiGeminiChatModel);
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
                SseUtil.send((String)"I cannot fulfill this request.", (String)"Chat Message Sent", null, (String)agentContext.getSseEventSinkKey());
            }
            return null;
        }));
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._noticeableExecutorService = this._portalExecutorManager.getPortalExecutor(SupervisorAgentImpl.class.getName());
    }

    @Deactivate
    protected void deactivate() {
        this._noticeableExecutorService.shutdown();
    }

    private void _invoke(AgentContext agentContext, Object[] agents, VertexAiGeminiChatModel vertexAiGeminiChatModel) {
        dev.langchain4j.agentic.supervisor.SupervisorAgent supervisorAgent = (dev.langchain4j.agentic.supervisor.SupervisorAgent)AgenticServices.supervisorBuilder().chatModel((ChatModel)vertexAiGeminiChatModel).maxAgentsInvocations(5).subAgents(agents).responseStrategy(SupervisorResponseStrategy.SUMMARY).build();
        SseUtil.send((String)supervisorAgent.invoke(MapUtil.getString((Map)agentContext.getInput(), (Object)"message")), (String)"Chat Message Sent", null, (String)agentContext.getSseEventSinkKey());
    }
}

