/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ai.hub.internal.agent;

import com.liferay.ai.hub.agent.AgentContext;
import com.liferay.ai.hub.agent.AgentsFactory;
import com.liferay.ai.hub.internal.agent.AgentSpecsProviderImpl;
import com.liferay.ai.hub.rest.manager.v1_0.TaskDefinitionManager;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.workflow.WorkflowInstanceManager;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.filter.ExpressionConvert;
import com.liferay.portal.odata.filter.FilterParser;
import com.liferay.portal.odata.filter.FilterParserProvider;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.util.Collection;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={AgentsFactory.class})
public class AgentsFactoryImpl
implements AgentsFactory {
    private static final Log _log = LogFactoryUtil.getLog(AgentsFactoryImpl.class);
    @Reference(target="(entity.model.name=TaskDefinition)")
    private EntityModel _entityModel;
    @Reference(target="(result.class.name=com.liferay.portal.kernel.search.filter.Filter)")
    private ExpressionConvert<Filter> _expressionConvert;
    @Reference
    private FilterParserProvider _filterParserProvider;
    @Reference
    private TaskDefinitionManager _taskDefinitionManager;
    @Reference
    private WorkflowInstanceManager _workflowInstanceManager;

    public Object[] create(AgentContext agentContext) {
        try {
            ServiceContext serviceContext = agentContext.getServiceContext();
            Page page = this._taskDefinitionManager.getTaskDefinitions(agentContext.getCompanyId(), null, this._toFilter(serviceContext.getLocale()), Pagination.of((int)1, (int)20), null, null);
            return TransformUtil.transformToArray((Collection)page.getItems(), taskDefinition -> new AgentSpecsProviderImpl(agentContext, taskDefinition.getDescription(), taskDefinition.getName(), taskDefinition.getVersion(), this._workflowInstanceManager), Object.class);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return new AgentSpecsProviderImpl[0];
        }
    }

    private Filter _toFilter(Locale locale) {
        try {
            FilterParser filterParser = this._filterParserProvider.provide(this._entityModel);
            com.liferay.portal.odata.filter.Filter oDataFilter = new com.liferay.portal.odata.filter.Filter(filterParser.parse("(active eq 1)"));
            return (Filter)this._expressionConvert.convert(oDataFilter.getExpression(), locale, this._entityModel);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return null;
        }
    }
}

