/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ai.hub.internal.workflow.kaleo.runtime.node;

import com.liferay.ai.hub.internal.assistant.handler.AssistantHandlerContext;
import com.liferay.ai.hub.internal.assistant.handler.AssistantHandlerUtil;
import com.liferay.ai.hub.internal.mcp.tool.provider.MCPToolProviderUtil;
import com.liferay.ai.hub.internal.workflow.kaleo.runtime.node.util.ContentRetrieverUtil;
import com.liferay.ai.hub.internal.workflow.kaleo.runtime.node.util.InputVariablesUtil;
import com.liferay.ai.hub.internal.workflow.kaleo.runtime.node.util.ToolsUtil;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowNodeManager;
import com.liferay.portal.vulcan.dto.converter.DTOConverterRegistry;
import com.liferay.portal.workflow.kaleo.definition.NodeType;
import com.liferay.portal.workflow.kaleo.model.KaleoInstanceToken;
import com.liferay.portal.workflow.kaleo.model.KaleoNode;
import com.liferay.portal.workflow.kaleo.model.KaleoNodeSetting;
import com.liferay.portal.workflow.kaleo.model.KaleoTransition;
import com.liferay.portal.workflow.kaleo.runtime.ExecutionContext;
import com.liferay.portal.workflow.kaleo.runtime.graph.PathElement;
import com.liferay.portal.workflow.kaleo.runtime.node.BaseNodeExecutor;
import com.liferay.portal.workflow.kaleo.runtime.node.NodeExecutor;
import com.liferay.portal.workflow.kaleo.service.KaleoNodeSettingLocalService;
import dev.langchain4j.agent.tool.P;
import dev.langchain4j.agent.tool.Tool;
import dev.langchain4j.invocation.InvocationParameters;
import dev.langchain4j.model.vertexai.gemini.VertexAiGeminiStreamingChatModel;
import dev.langchain4j.service.tool.ToolProvider;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={NodeExecutor.class})
public class AIDecisionNodeExecutor
extends BaseNodeExecutor {
    @Reference
    private DTOConverterRegistry _dtoConverterRegistry;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private KaleoNodeSettingLocalService _kaleoNodeSettingLocalService;
    @Reference(target="(object.entry.manager.storage.type=default)")
    private ObjectEntryManager _objectEntryManager;
    @Reference
    private WorkflowNodeManager _workflowNodeManager;

    public NodeType getNodeType() {
        return NodeType.AI_DECISION;
    }

    protected boolean doEnter(KaleoNode currentKaleoNode, ExecutionContext executionContext) {
        return true;
    }

    protected void doExecute(KaleoNode currentKaleoNode, ExecutionContext executionContext, List<PathElement> remainingPathElements) throws PortalException {
        KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
        HashMap<String, String> kaleoNodeSettingValues = new HashMap<String, String>();
        List kaleoNodeSettings = this._kaleoNodeSettingLocalService.getKaleoNodeSettings(currentKaleoNode.getKaleoNodeId());
        for (KaleoNodeSetting kaleoNodeSetting : kaleoNodeSettings) {
            kaleoNodeSettingValues.put(kaleoNodeSetting.getName(), kaleoNodeSetting.getValue());
        }
        ServiceContext serviceContext = executionContext.getServiceContext();
        VertexAiGeminiStreamingChatModel vertexAiGeminiStreamingChatModel = VertexAiGeminiStreamingChatModel.builder().project("ai-hub-liferay").location("us-central1").modelName("gemini-2.5-flash-lite").build();
        AssistantHandlerUtil.handle(AssistantHandlerContext.builder().contentRetriever(ContentRetrieverUtil.createContentRetriever(kaleoNodeSettingValues)).invocationParameters(InvocationParameters.from(Map.of("executionContext", executionContext, "permissionChecker", PermissionThreadLocal.getPermissionChecker()))).onCompleteResponse(response -> vertexAiGeminiStreamingChatModel.close()).onError(throwable -> vertexAiGeminiStreamingChatModel.close()).systemMessageProvider(object -> InputVariablesUtil.applyInputVariables(executionContext, "prompt", kaleoNodeSettingValues)).tools(new Tools()).toolProvider((ToolProvider)MCPToolProviderUtil.create(kaleoInstanceToken.getCompanyId(), this._dtoConverterRegistry, kaleoInstanceToken.getGroupId(), serviceContext.getLocale(), ToolsUtil.getMCPServerExternalReferenceCodes(this._jsonFactory, kaleoNodeSettingValues), this._objectEntryManager, serviceContext.getUserId())).userMessage(InputVariablesUtil.applyInputVariables(executionContext, "userMessage", kaleoNodeSettingValues)).vertexAiGeminiStreamingChatModel(vertexAiGeminiStreamingChatModel).build(), "default");
    }

    protected void doExit(KaleoNode currentKaleoNode, ExecutionContext executionContext, List<PathElement> remainingPathElements) throws PortalException {
        KaleoTransition kaleoTransition = null;
        kaleoTransition = Validator.isNull((String)executionContext.getTransitionName()) ? currentKaleoNode.getDefaultKaleoTransition() : currentKaleoNode.getKaleoTransition(executionContext.getTransitionName());
        remainingPathElements.add(new PathElement(null, kaleoTransition.getTargetKaleoNode(), new ExecutionContext(executionContext.getKaleoInstanceToken(), executionContext.getWorkflowContext(), executionContext.getServiceContext())));
    }

    public class Tools {
        @Tool(value={"Complete the workflow node by proceeding to the chosen transition"})
        public void completeWorkflowNode(InvocationParameters invocationParameters, @P(value="A brief, one-sentence justification for the chosen transition.") String reason, @P(value="Transition name") String transitionName) throws PortalException {
            ExecutionContext executionContext = (ExecutionContext)invocationParameters.get("executionContext");
            Map workflowContext = executionContext.getWorkflowContext();
            workflowContext.put("reason", reason);
            PermissionThreadLocal.setPermissionChecker((PermissionChecker)((PermissionChecker)invocationParameters.get("permissionChecker")));
            KaleoInstanceToken kaleoInstanceToken = executionContext.getKaleoInstanceToken();
            AIDecisionNodeExecutor.this._workflowNodeManager.completeWorkflowNode(kaleoInstanceToken.getCompanyId(), kaleoInstanceToken.getUserId(), kaleoInstanceToken.getKaleoInstanceTokenId(), transitionName, workflowContext, false);
        }
    }
}

