/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ai.hub.security;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.SecureRandomUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.MACSigner;
import com.nimbusds.jose.crypto.MACVerifier;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.util.Date;

public class JWTTokenUtil {
    private static final byte[] _SECRET;
    private static final Log _log;

    public static String generateToken(long expirationTime, String issuer, long userId) {
        Date now = new Date();
        SignedJWT signedJWT = new SignedJWT(new JWSHeader(JWSAlgorithm.HS256), new JWTClaimsSet.Builder().expirationTime(new Date(now.getTime() + expirationTime)).issuer(issuer).issueTime(now).subject(String.valueOf(userId)).build());
        try {
            signedJWT.sign((JWSSigner)new MACSigner(_SECRET));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to generate a signed token", (Throwable)exception);
            }
            return null;
        }
        return signedJWT.serialize();
    }

    public static long getUserId(String token) {
        JWTClaimsSet jwtClaimsSet = null;
        try {
            SignedJWT signedJWT = SignedJWT.parse((String)token);
            if (!signedJWT.verify((JWSVerifier)new MACVerifier(_SECRET))) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Invalid JWT signature");
                }
                return 0L;
            }
            jwtClaimsSet = signedJWT.getJWTClaimsSet();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to parse and verify the JWT token", (Throwable)exception);
            }
            return 0L;
        }
        Date expirationDate = jwtClaimsSet.getExpirationTime();
        if (expirationDate == null || expirationDate.before(new Date())) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"The JWT token is expired");
            }
            return 0L;
        }
        return GetterUtil.getLong((String)jwtClaimsSet.getSubject());
    }

    static {
        _log = LogFactoryUtil.getLog(JWTTokenUtil.class);
        int sha256BlockSize = 64;
        byte[] secret = new byte[sha256BlockSize];
        for (int i = 0; i < secret.length; ++i) {
            secret[i] = SecureRandomUtil.nextByte();
        }
        _SECRET = secret;
    }
}

