/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.ai.hub.agent;

import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import java.util.Map;

public class AgentContext {
    private final String _accessToken;
    private final long _companyId;
    private final DTOConverterContext _dtoConverterContext;
    private final long _groupId;
    private final Map<String, Object> _input;
    private final ServiceContext _serviceContext;
    private final String _sseEventSinkKey;
    private final long _userId;
    private final String _userToken;

    public static Builder builder() {
        return new Builder();
    }

    public AgentContext(Builder builder) {
        this._accessToken = builder._accessToken;
        this._companyId = builder._companyId;
        this._dtoConverterContext = builder._dtoConverterContext;
        this._groupId = builder._groupId;
        this._input = builder._input;
        this._serviceContext = builder._serviceContext;
        this._sseEventSinkKey = builder._sseEventSinkKey;
        this._userId = builder._userId;
        this._userToken = builder._userToken;
    }

    public String getAccessToken() {
        return this._accessToken;
    }

    public long getCompanyId() {
        return this._companyId;
    }

    public DTOConverterContext getDTOConverterContext() {
        return this._dtoConverterContext;
    }

    public long getGroupId() {
        return this._groupId;
    }

    public Map<String, Object> getInput() {
        return this._input;
    }

    public ServiceContext getServiceContext() {
        return this._serviceContext;
    }

    public String getSseEventSinkKey() {
        return this._sseEventSinkKey;
    }

    public long getUserId() {
        return this._userId;
    }

    public String getUserToken() {
        return this._userToken;
    }

    public static class Builder {
        private String _accessToken;
        private long _companyId;
        private DTOConverterContext _dtoConverterContext;
        private long _groupId;
        private Map<String, Object> _input;
        private ServiceContext _serviceContext;
        private String _sseEventSinkKey;
        private long _userId;
        private String _userToken;

        public Builder accessToken(String accessToken) {
            this._accessToken = accessToken;
            return this;
        }

        public AgentContext build() {
            return new AgentContext(this);
        }

        public Builder companyId(long companyId) {
            this._companyId = companyId;
            return this;
        }

        public Builder dtoConverterContext(DTOConverterContext dtoConverterContext) {
            this._dtoConverterContext = dtoConverterContext;
            return this;
        }

        public Builder groupId(long groupId) {
            this._groupId = groupId;
            return this;
        }

        public Builder input(Map<String, Object> input) {
            this._input = input;
            return this;
        }

        public Builder serviceContext(ServiceContext serviceContext) {
            this._serviceContext = serviceContext;
            return this;
        }

        public Builder sseEventSinkKey(String sseEventSinkKey) {
            this._sseEventSinkKey = sseEventSinkKey;
            return this;
        }

        public Builder userId(long userId) {
            this._userId = userId;
            return this;
        }

        public Builder userToken(String userToken) {
            this._userToken = userToken;
            return this;
        }
    }
}

