/*
 * Decompiled with CFR 0.152.
 */
package com.legstar.codegen;

import com.legstar.codegen.CodeGenMakeException;
import com.legstar.codegen.CodeGenVelocityException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CodeGenUtil {
    public static final String DATE_FORMAT_NOW = "yyyy-MM-dd HH:mm:ss";
    private static Random mRandom = new Random();
    public static final String JAXB_TYPE_SUFFIX = "Type";
    public static final String CRLF = System.getProperty("line.separator");
    private static final Log LOG = LogFactory.getLog(CodeGenUtil.class);

    private CodeGenUtil() {
    }

    public static void checkDirectory(String dir, boolean create, String errorDirName) {
        try {
            CodeGenUtil.checkDirectory(dir, create);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(errorDirName + ": " + e.getMessage());
        }
    }

    public static void checkDirectory(File fdir, boolean create, String errorDirName) {
        try {
            CodeGenUtil.checkDirectory(fdir, create);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(errorDirName + ": " + e.getMessage());
        }
    }

    public static void checkDirectory(String dir, boolean create) {
        if (dir == null || dir.length() == 0) {
            throw new IllegalArgumentException("No directory name was specified");
        }
        CodeGenUtil.checkDirectory(new File(dir), create);
    }

    public static void checkDirectory(File fdir, boolean create) {
        if (fdir == null) {
            throw new IllegalArgumentException("No directory name was specified");
        }
        if (!fdir.exists()) {
            if (!create) {
                throw new IllegalArgumentException(fdir.getName() + " does not exist");
            }
            if (!fdir.mkdirs()) {
                throw new IllegalArgumentException("Could not create directory " + fdir.getName());
            }
            return;
        }
        if (!fdir.isDirectory()) {
            throw new IllegalArgumentException(fdir.getName() + " is not a directory");
        }
        if (!fdir.canWrite()) {
            throw new IllegalArgumentException("Directory " + fdir.getName() + " is not writable");
        }
    }

    public static File getFile(String dir, String filename) {
        File file = new File(filename);
        if (file.isAbsolute()) {
            return file;
        }
        if (dir == null || dir.length() == 0) {
            return new File(filename);
        }
        return new File(dir, filename);
    }

    public static File getFile(File fdir, String filename) {
        File file = new File(filename);
        if (file.isAbsolute()) {
            return file;
        }
        return new File(fdir, filename);
    }

    public static String classNormalize(String noun) {
        String className = null;
        if (noun != null && noun.length() > 0) {
            className = noun.substring(0, 1).toUpperCase();
            if (noun.length() > 1) {
                className = className + noun.substring(1, noun.length());
            }
        }
        return className;
    }

    public static String relativeLocation(String packageName) {
        if (packageName == null || packageName.length() == 0) {
            return "";
        }
        String loc = packageName.replace('.', '/');
        if (loc.charAt(0) != '/') {
            loc = '/' + loc;
        }
        if (loc.charAt(loc.length() - 1) != '/') {
            loc = loc + '/';
        }
        return loc;
    }

    public static String classFilesLocation(String rootDirName, String packageName, boolean create) {
        if (rootDirName == null || rootDirName.length() == 0) {
            throw new IllegalArgumentException("No root directory name was specified");
        }
        String dir = packageName != null && packageName.length() > 0 ? rootDirName + '/' + CodeGenUtil.relativeLocation(packageName) : rootDirName;
        if (create) {
            CodeGenUtil.checkDirectory(dir, true);
        }
        return dir;
    }

    public static File classFilesLocation(File rootDir, String packageName, boolean create) {
        File dir = rootDir;
        if (packageName != null && packageName.length() > 0) {
            dir = new File(rootDir, CodeGenUtil.relativeLocation(packageName));
        }
        if (create) {
            CodeGenUtil.checkDirectory(dir, true);
        }
        return dir;
    }

    public static void initVelocity() throws CodeGenVelocityException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            Velocity.addProperty((String)"resource.loader", (Object)"classpath");
            Velocity.addProperty((String)"classpath.resource.loader.description", (Object)"Velocity Classpath Resource Loader");
            Velocity.addProperty((String)"classpath.resource.loader.class", (Object)"org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
            Velocity.addProperty((String)"classpath.resource.loader.cache", (Object)true);
            Thread.currentThread().setContextClassLoader(Velocity.class.getClassLoader());
            Velocity.init();
        }
        catch (Exception e) {
            throw new CodeGenVelocityException(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(loader);
        }
    }

    public static VelocityContext getContext(String generatorName) {
        VelocityContext context = new VelocityContext();
        context.put("formattedDate", (Object)CodeGenUtil.now());
        context.put("generatorName", (Object)generatorName);
        return context;
    }

    public static void processTemplate(String generatorName, String templateName, String modelName, Object model, Map<String, Object> parameters, File targetFile) throws CodeGenMakeException {
        CodeGenUtil.processTemplate(generatorName, templateName, modelName, model, parameters, targetFile, null);
    }

    public static void processTemplate(String generatorName, String templateName, String modelName, Object model, Map<String, Object> parameters, File targetFile, String targetCharsetName) throws CodeGenMakeException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Processing template");
            LOG.debug((Object)("Template name       = " + templateName));
            LOG.debug((Object)("Target file         = " + targetFile));
            LOG.debug((Object)("Target charset name = " + targetCharsetName));
            if (parameters != null) {
                for (String key : parameters.keySet()) {
                    Object value = parameters.get(key);
                    LOG.debug((Object)("Parameter " + key + " = " + value));
                }
            }
        }
        VelocityContext context = CodeGenUtil.getContext(generatorName);
        context.put(modelName, model);
        context.put("serialVersionID", (Object)(Long.toString(mRandom.nextLong()) + 'L'));
        if (parameters != null) {
            for (String key : parameters.keySet()) {
                context.put(key, parameters.get(key));
            }
        }
        StringWriter w = new StringWriter();
        try {
            Velocity.mergeTemplate((String)templateName, (String)"UTF-8", (Context)context, (Writer)w);
            Writer out = null;
            try {
                FileOutputStream fos = new FileOutputStream(targetFile);
                OutputStreamWriter osw = targetCharsetName == null ? new OutputStreamWriter(fos) : new OutputStreamWriter((OutputStream)fos, targetCharsetName);
                out = new BufferedWriter(osw);
                out.write(w.toString());
            }
            catch (IOException e) {
                throw new CodeGenMakeException(e);
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (ResourceNotFoundException e) {
            throw new CodeGenMakeException((Exception)((Object)e));
        }
        catch (ParseErrorException e) {
            throw new CodeGenMakeException((Exception)((Object)e));
        }
        catch (MethodInvocationException e) {
            throw new CodeGenMakeException((Exception)((Object)e));
        }
        catch (Exception e) {
            throw new CodeGenMakeException(e);
        }
    }

    public static String now() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
        return sdf.format(cal.getTime());
    }

    public static void checkHttpURI(String httpUri) throws CodeGenMakeException {
        try {
            if (httpUri == null || httpUri.length() == 0) {
                throw new CodeGenMakeException("You must specify a valid URI");
            }
            URI uri = new URI(httpUri);
            if (uri.getScheme() == null || uri.getScheme().compareToIgnoreCase("http") != 0) {
                throw new CodeGenMakeException("URI " + uri + " must have http scheme");
            }
        }
        catch (URISyntaxException e) {
            throw new CodeGenMakeException(e);
        }
    }

    public static void checkCharset(String charset) throws CodeGenMakeException {
        if (charset == null || charset.length() == 0) {
            throw new CodeGenMakeException("You must specify a valid character set");
        }
        if (!Charset.isSupported(charset)) {
            throw new CodeGenMakeException("Character set " + charset + " is not supported");
        }
    }

    public static String fieldNameFromPropertyName(String propertyName) {
        String fieldName = null;
        if (propertyName != null && propertyName.length() > 0) {
            fieldName = propertyName.substring(0, 1).toLowerCase();
            if (propertyName.length() > 1) {
                fieldName = fieldName + propertyName.substring(1, propertyName.length());
            }
        }
        return fieldName;
    }

    public static String propertyNameFromFieldName(String fieldName) {
        String propertyName = null;
        if (fieldName != null && fieldName.length() > 0) {
            propertyName = fieldName.substring(0, 1).toUpperCase();
            if (fieldName.length() > 1) {
                propertyName = propertyName + fieldName.substring(1, fieldName.length());
            }
        }
        return propertyName;
    }

    public static String propertyNameFromJaxbType(String jaxbType) {
        String propertyName = null;
        if (jaxbType != null && jaxbType.length() > 0 && (propertyName = jaxbType).endsWith(JAXB_TYPE_SUFFIX)) {
            propertyName = propertyName.substring(0, propertyName.length() - JAXB_TYPE_SUFFIX.length());
        }
        return propertyName;
    }

    public static String getLocalIPAddress() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            byte[] ipAddr = addr.getAddress();
            String ipAddrStr = "";
            for (int i = 0; i < ipAddr.length; ++i) {
                if (i > 0) {
                    ipAddrStr = ipAddrStr + ".";
                }
                ipAddrStr = ipAddrStr + (ipAddr[i] & 0xFF);
            }
            return ipAddrStr;
        }
        catch (UnknownHostException e) {
            return "";
        }
    }
}

