/*
 * Decompiled with CFR 0.152.
 */
package com.leafready.ads.utils;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.leafready.ads.AdsManager;
import com.leafready.ads.utils.DebugConfigs;
import com.leafready.ads.utils.DeviceUtils;
import com.leafready.ads.utils.EncryptionUtils;
import com.leafready.ads.utils.LogUtils;
import com.leafready.ads.utils.Utils;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.QueryMap;
import retrofit2.http.Url;

public class NetService {
    private boolean encryptEnable = false;
    private static NetService INSTANCE;
    private final Context context;

    public NetService(Context context) {
        this.context = context;
    }

    public static NetService getInstance(Context context) {
        if (INSTANCE == null) {
            return new NetService(context);
        }
        return INSTANCE;
    }

    public BaseService getRequestService() {
        try {
            OkHttpClient.Builder builder = new OkHttpClient.Builder().readTimeout(20L, TimeUnit.SECONDS).connectTimeout(30L, TimeUnit.SECONDS);
            HttpInterceptor httpInterceptor = new HttpInterceptor(this.context);
            httpInterceptor.encryptEnable = this.encryptEnable;
            builder.addInterceptor((Interceptor)httpInterceptor);
            if (DebugConfigs.isDebugEnable(this.context)) {
                HttpLoggingInterceptor interceptor = new HttpLoggingInterceptor();
                interceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
                builder.addInterceptor((Interceptor)interceptor);
            }
            OkHttpClient defaultHttpClient = builder.build();
            Retrofit retrofit = new Retrofit.Builder().baseUrl("http://kasinr.fltinhalq.com").client(defaultHttpClient).build();
            return (BaseService)retrofit.create(BaseService.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return (BaseService)new Retrofit.Builder().baseUrl("http://kasinr.fltinhalq.com").build().create(BaseService.class);
        }
    }

    public NetService encryptEnable(boolean enable) {
        this.encryptEnable = enable;
        return this;
    }

    static class HttpInterceptor
    implements Interceptor {
        private static final String TAG = "HttpInterceptor";
        private Context mContext;
        private boolean encryptEnable = false;

        public HttpInterceptor(Context context) {
            this.mContext = context;
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request.Builder requestBuilder = chain.request().newBuilder();
            try {
                String advertisingId = Utils.getAdvertisingID(this.mContext);
                if (advertisingId != null) {
                    requestBuilder.addHeader("ccavstid", advertisingId);
                }
                if (AdsManager.getApiKey() != null) {
                    requestBuilder.addHeader("X-Request", AdsManager.getApiKey());
                }
                requestBuilder.addHeader("ccosand", Utils.getVersionOS(this.mContext));
                requestBuilder.addHeader("cctypenet\t", Utils.getNetworkType(this.mContext));
                requestBuilder.addHeader("cclangu", Utils.getLanguage(this.mContext));
                String LOG_CHIEUFTHIETSBI = DeviceUtils.getMarResolution(this.mContext);
                Log.d((String)TAG, (String)("resolution : " + LOG_CHIEUFTHIETSBI));
                requestBuilder.addHeader("ccresution", LOG_CHIEUFTHIETSBI);
                requestBuilder.addHeader("ccsver", "2.5.2");
                if (AdsManager.getUserId() != null) {
                    requestBuilder.addHeader("cciduser", AdsManager.getUserId());
                }
                if ("post".equalsIgnoreCase(chain.request().method()) && AdsManager.getUserId() != null && Utils.getPackageName(this.mContext) != null) {
                    requestBuilder.addHeader("cciduser", AdsManager.getUserId());
                    requestBuilder.addHeader("ccnamepack", Utils.getPackageName(this.mContext));
                }
                if (this.encryptEnable) {
                    String url = chain.request().url().toString();
                    Uri uri = Uri.parse((String)url);
                    if (uri.getQueryParameter("sign") == null) {
                        url = uri.buildUpon().appendQueryParameter("sign", EncryptionUtils.getSignString(this.mContext)).build().toString();
                    }
                    requestBuilder.url(url);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Request request = requestBuilder.build();
            Log.i((String)TAG, (String)("Request URL: " + request.url()));
            Response response = chain.proceed(request);
            try {
                String responseStringData = response.body().string();
                MediaType contentType = response.body().contentType();
                if (!TextUtils.isEmpty((CharSequence)responseStringData) && this.encryptEnable && !this.isJsonString(responseStringData)) {
                    try {
                        String convertHex2Accii = EncryptionUtils.hexToASCII(responseStringData);
                        byte[] decodeFromBase64 = Base64.decode((String)convertHex2Accii, (int)0);
                        responseStringData = EncryptionUtils.decrytionDataBlowfish(decodeFromBase64);
                    }
                    catch (NumberFormatException numberFormatException) {
                        LogUtils.loge(this.mContext, numberFormatException);
                    }
                    catch (Exception exception) {
                        LogUtils.loge(this.mContext, exception);
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)responseStringData)) {
                    ResponseBody body = ResponseBody.create((MediaType)contentType, (String)responseStringData);
                    return response.newBuilder().body(body).build();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return response;
        }

        private boolean isJsonString(String jsonString) {
            try {
                new JSONObject(jsonString);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    static interface BaseService {
        @POST
        public Call<ResponseBody> post(@Url String var1, @QueryMap HashMap<String, String> var2);

        @POST
        public Call<ResponseBody> post(@Url String var1);

        @PUT
        public Call<ResponseBody> put(@Url String var1, @QueryMap HashMap<String, String> var2);

        @GET
        public Call<ResponseBody> get(@Url String var1);
    }
}

