/*
 * Decompiled with CFR 0.152.
 */
package com.leafready.ads.utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.renderscript.Type;
import android.util.Log;
import com.leafready.ads.utils.Utils;
import com.leafready.ads.views.MobileImageView;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class GifUtils {
    private static final float BLUR_RADIUS = 25.0f;
    private static RenderScript rs;
    private static ScriptIntrinsicBlur script;
    private static Allocation input;
    private static Allocation output;
    private static boolean configured;
    private static Bitmap tmp;
    private static int[] pixels;

    public static boolean isGif(byte[] data) {
        if (data != null) {
            try {
                ByteBuffer rawData = ByteBuffer.wrap(data);
                rawData.rewind();
                rawData.order(ByteOrder.LITTLE_ENDIAN);
                String id2 = "";
                for (int i = 0; i < 6; ++i) {
                    int curByte = 0;
                    try {
                        curByte = rawData.get() & 0xFF;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    id2 = id2 + (char)curByte;
                }
                if (id2.startsWith("GIF")) {
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return false;
    }

    @SuppressLint(value={"NewApi"})
    public static Bitmap blur(Activity activity, Bitmap image) {
        if (image == null) {
            return null;
        }
        image = GifUtils.RGB565toARGB888(activity, image);
        if (!configured) {
            rs = RenderScript.create((Context)activity);
            input = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)image);
            output = Allocation.createTyped((RenderScript)rs, (Type)input.getType());
            script = ScriptIntrinsicBlur.create((RenderScript)rs, (Element)Element.U8_4((RenderScript)rs));
            script.setRadius(25.0f);
            configured = true;
        } else {
            input.copyFrom(image);
        }
        script.setInput(input);
        script.forEach(output);
        output.copyTo(image);
        return image;
    }

    @SuppressLint(value={"NewApi"})
    public static Bitmap blur(Activity activity, Bitmap image, int widthInPixel, int heightInPixel) {
        try {
            if (image == null) {
                return null;
            }
            image = GifUtils.RGB565toARGB888(activity, image, widthInPixel, heightInPixel);
            if (!configured) {
                rs = RenderScript.create((Context)activity);
                input = Allocation.createFromBitmap((RenderScript)rs, (Bitmap)image);
                output = Allocation.createTyped((RenderScript)rs, (Type)input.getType());
                script = ScriptIntrinsicBlur.create((RenderScript)rs, (Element)Element.U8_4((RenderScript)rs));
                script.setRadius(25.0f);
                configured = true;
            } else {
                input.copyFrom(image);
            }
            script.setInput(input);
            script.forEach(output);
            output.copyTo(image);
            return image;
        }
        catch (Exception e) {
            e.printStackTrace();
            Bitmap bitmap = Bitmap.createBitmap((int)100, (int)100, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.eraseColor(-1);
            return bitmap;
        }
    }

    private static Bitmap RGB565toARGB888(Activity activity, Bitmap img) {
        try {
            int numPixels = img.getWidth() * img.getHeight();
            if (tmp == null) {
                tmp = Bitmap.createBitmap((int)img.getWidth(), (int)img.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Log.i((String)"TAG Blur", (String)("width:" + img.getWidth() + ", heght:" + img.getHeight()));
                pixels = new int[numPixels];
            }
            img.getPixels(pixels, 0, img.getWidth(), 0, 0, img.getWidth(), img.getHeight());
            tmp.setPixels(pixels, 0, tmp.getWidth(), 0, 0, tmp.getWidth(), tmp.getHeight());
            return tmp;
        }
        catch (Exception e) {
            e.printStackTrace();
            Bitmap bitmap = Bitmap.createBitmap((int)100, (int)100, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.eraseColor(-1);
            return bitmap;
        }
    }

    public static Bitmap RGB565toARGB888(Activity activity, Bitmap image, int widthInPixel, int heightInPixel) {
        try {
            int numPixels = widthInPixel * heightInPixel;
            if (tmp == null) {
                tmp = Bitmap.createBitmap((int)widthInPixel, (int)heightInPixel, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                Log.i((String)"TAG Blur", (String)("width:" + image.getWidth() + ", heght:" + image.getHeight()));
                pixels = new int[numPixels];
            }
            image.getPixels(pixels, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
            tmp.setPixels(pixels, 0, tmp.getWidth(), 0, 0, tmp.getWidth(), tmp.getHeight());
            return tmp;
        }
        catch (Exception e) {
            e.printStackTrace();
            Bitmap bitmap = Bitmap.createBitmap((int)100, (int)100, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.eraseColor(-1);
            return bitmap;
        }
    }

    public static float[] loadBytesToGifImage(Context c, byte[] bytes, MobileImageView imageView, boolean resize) {
        float[] resizeImage = new float[]{0.0f, 0.0f};
        try {
            if (!GifUtils.isGif(bytes)) {
                Bitmap bitmap = Utils.getBitmapfromBytes(bytes);
                resizeImage = Utils.getProperSizeForIntertitialImage(c, bitmap);
                Bitmap bitmapResult = bitmap;
                if (resize) {
                    bitmapResult = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)((int)resizeImage[0]), (int)((int)resizeImage[1]), (boolean)true);
                }
                if (imageView != null) {
                    imageView.setImageBitmap(bitmapResult);
                }
                return resizeImage;
            }
            if (imageView != null) {
                imageView.setBytes(bytes);
                imageView.startAnimation();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resizeImage;
    }

    static {
        configured = false;
        tmp = null;
        pixels = null;
    }
}

