/*
 * Decompiled with CFR 0.152.
 */
package com.leafready.ads.utils;

import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Point;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.KeyCharacterMap;
import android.view.ViewConfiguration;
import android.view.WindowManager;
import com.leafready.ads.utils.SharedPreferenceUtils;
import com.leafready.ads.utils.Utils;
import java.lang.reflect.InvocationTargetException;

public class DeviceUtils {
    private static final String TAG = DeviceUtils.class.getSimpleName();

    public static float getDensity(Context context) {
        return context.getResources().getDisplayMetrics().density;
    }

    public static int getScreenWidthInPixels(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    public static int getScreenHeightInPixels(Context context) {
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    public static float getScaleFactor(Context context) {
        return context.getResources().getDisplayMetrics().density;
    }

    public static double getScreenInch(Context context) {
        DisplayMetrics dm = context.getResources().getDisplayMetrics();
        double x = Math.pow((float)dm.widthPixels / dm.xdpi, 2.0);
        double y = Math.pow((float)dm.heightPixels / dm.ydpi, 2.0);
        return Math.sqrt(x + y);
    }

    @SuppressLint(value={"NewApi"})
    public static int getRealScreenWidthInPixels(Context context) {
        try {
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            Display display = windowManager.getDefaultDisplay();
            Point size = new Point();
            if (Build.VERSION.SDK_INT >= 17) {
                display.getRealSize(size);
            } else if (Build.VERSION.SDK_INT >= 14) {
                try {
                    size.x = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)display, new Object[0]);
                    size.y = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)display, new Object[0]);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return size.x;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @SuppressLint(value={"NewApi"})
    public static int getRealScreenHeightInPixels(Context context) {
        try {
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            Display display = windowManager.getDefaultDisplay();
            Point size = new Point();
            if (Build.VERSION.SDK_INT >= 17) {
                display.getRealSize(size);
            } else if (Build.VERSION.SDK_INT >= 14) {
                try {
                    size.x = (Integer)Display.class.getMethod("getRawWidth", new Class[0]).invoke((Object)display, new Object[0]);
                    size.y = (Integer)Display.class.getMethod("getRawHeight", new Class[0]).invoke((Object)display, new Object[0]);
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return size.y;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static int getStatusBarHeightInPixels(Context context) {
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            return resources.getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    public static int getNavigationBarHeightInPixels(Context context) {
        return DeviceUtils.getRealScreenHeightInPixels(context) - DeviceUtils.getScreenHeightInPixels(context);
    }

    public static int getScreenOrientation(Context context) {
        try {
            if (context.getResources().getConfiguration().orientation == 1) {
                return 1;
            }
            if (context.getResources().getConfiguration().orientation == 2) {
                return 2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    @SuppressLint(value={"NewApi"})
    public static boolean isNavigationBarOnBottom(Context context) {
        Resources res = context.getResources();
        Configuration cfg = res.getConfiguration();
        DisplayMetrics dm = res.getDisplayMetrics();
        boolean canMove = dm.widthPixels != dm.heightPixels && cfg.smallestScreenWidthDp < 600;
        return !canMove || dm.widthPixels < dm.heightPixels;
    }

    @SuppressLint(value={"NewApi"})
    public static boolean isNavigationBarAvailable(Context context) {
        try {
            return ViewConfiguration.get((Context)context).hasPermanentMenuKey();
        }
        catch (Exception e) {
            boolean hasBackKey = KeyCharacterMap.deviceHasKey((int)4);
            boolean hasHomeKey = KeyCharacterMap.deviceHasKey((int)3);
            return !hasBackKey || !hasHomeKey;
        }
    }

    public static String getResolution(Context c) {
        try {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            ((WindowManager)c.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
            String wh = displayMetrics.widthPixels + "x" + displayMetrics.heightPixels;
            return wh;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getSDKVersion() {
        return String.valueOf(Build.VERSION.SDK_INT);
    }

    public static String getOSInfo() {
        return Build.MANUFACTURER + " " + Build.PRODUCT + " " + Build.VERSION.RELEASE;
    }

    public static String getDevice() {
        return Build.MODEL;
    }

    public static String getDeviceID(Context c) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)c.getSystemService("phone");
            String deviceId = null;
            int phoneType = telephonyManager.getPhoneType();
            Log.i((String)"getDeviceID", (String)("--phoneType:" + phoneType));
            switch (phoneType) {
                case 0: 
                case 2: 
                case 3: {
                    deviceId = telephonyManager.getDeviceId();
                    break;
                }
                case 1: {
                    deviceId = telephonyManager.getSubscriberId();
                    break;
                }
                default: {
                    deviceId = null;
                }
            }
            return deviceId;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getAndroidID(Context c) {
        try {
            return Settings.Secure.getString((ContentResolver)c.getContentResolver(), (String)"android_id");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getUniqueDeviceID(Context c) {
        try {
            String id2 = DeviceUtils.getAndroidID(c);
            if (TextUtils.isEmpty((CharSequence)id2)) {
                id2 = DeviceUtils.getDeviceID(c);
            }
            Log.i((String)TAG, (String)("getUniqueDeviceID: " + id2));
            return Utils.getSHACheckSum(id2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getDeviceModel() {
        Log.i((String)TAG, (String)("model: " + Build.MODEL));
        return Build.MODEL;
    }

    public static void saveMarResolution(Context mContext) {
        try {
            String LOG_CHIEUFTHIETSBI = DeviceUtils.getRealScreenWidthInPixels(mContext) + "-" + DeviceUtils.getRealScreenHeightInPixels(mContext) + "-" + DeviceUtils.getScreenOrientation(mContext);
            Log.d((String)TAG, (String)("mar_resolution_log1:" + LOG_CHIEUFTHIETSBI));
            SharedPreferenceUtils.saveStringValue(mContext, "save_value_resolution", LOG_CHIEUFTHIETSBI);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getMarResolution(Context mContext) {
        try {
            String mar_resolution = SharedPreferenceUtils.getStringValue(mContext, "save_value_resolution");
            Log.d((String)TAG, (String)("mar_resolution_log2:" + mar_resolution));
            return mar_resolution;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }
}

