/*
 * Decompiled with CFR 0.152.
 */
package com.leafready.ads.utils;

import android.annotation.SuppressLint;
import android.view.MotionEvent;
import android.view.View;
import com.leafready.ads.utils.LogUtils;

public class ClickOutsideDetector {
    private static final String TAG = "ClickEventDetector";
    private static float mDownX;
    private static float mDownY;
    private static final float SCROLL_THRESHOLD = 10.0f;
    private static boolean isOnClick;

    public static void setOnTouchEvent(ClickListener clickListener, View ... views) {
        for (int i = 0; i < views.length; ++i) {
            ClickOutsideDetector.setListener(views[i], clickListener);
        }
    }

    public static void setListener(final View view, final ClickListener listener) {
        final View viewFinal = view;
        view.setOnTouchListener(new View.OnTouchListener(){

            @SuppressLint(value={"ClickableViewAccessibility"})
            public boolean onTouch(View arg0, MotionEvent ev) {
                try {
                    switch (ev.getAction() & 0xFF) {
                        case 0: {
                            mDownX = ev.getX();
                            mDownY = ev.getY();
                            isOnClick = true;
                            break;
                        }
                        case 1: 
                        case 3: {
                            if (!isOnClick) break;
                            LogUtils.log(view.getContext(), ClickOutsideDetector.TAG, "onClick ");
                            if (listener == null) break;
                            listener.onClick(viewFinal);
                            break;
                        }
                        case 2: {
                            if (!isOnClick || !(Math.abs(mDownX - ev.getX()) > 10.0f) && !(Math.abs(mDownY - ev.getY()) > 10.0f)) break;
                            LogUtils.log(view.getContext(), ClickOutsideDetector.TAG, "movement detected");
                            isOnClick = false;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return false;
            }
        });
        view.setOnLongClickListener(new View.OnLongClickListener(){

            public boolean onLongClick(View arg0) {
                return false;
            }
        });
    }

    static {
        isOnClick = false;
    }

    public static interface ClickListener {
        public void onClick(View var1);
    }
}

