/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.eventsource;

import com.launchdarkly.eventsource.ConnectionHandler;
import com.launchdarkly.eventsource.EventHandler;
import com.launchdarkly.eventsource.LazyStackTrace;
import com.launchdarkly.eventsource.Logger;
import com.launchdarkly.eventsource.MessageEvent;
import java.net.URI;
import java.time.Duration;
import java.util.regex.Pattern;

public class EventParser {
    private static final String DATA = "data";
    private static final String ID = "id";
    private static final String EVENT = "event";
    private static final String RETRY = "retry";
    private static final String DEFAULT_EVENT = "message";
    private static final String EMPTY_STRING = "";
    private static final Pattern DIGITS_ONLY = Pattern.compile("^[\\d]+$");
    private final EventHandler handler;
    private final ConnectionHandler connectionHandler;
    private final Logger logger;
    private final URI origin;
    private StringBuffer data = new StringBuffer();
    private String lastEventId;
    private String eventName = "message";

    EventParser(URI origin, EventHandler handler, ConnectionHandler connectionHandler, Logger logger) {
        this.handler = handler;
        this.origin = origin;
        this.connectionHandler = connectionHandler;
        this.logger = logger;
    }

    public void line(String line) {
        this.logger.debug("Parsing line: {}", line);
        if (line.trim().isEmpty()) {
            this.dispatchEvent();
        } else if (line.startsWith(":")) {
            this.processComment(line.substring(1).trim());
        } else {
            int colonIndex = line.indexOf(":");
            if (colonIndex != -1) {
                String field = line.substring(0, colonIndex);
                String value = line.substring(colonIndex + 1);
                if (!value.isEmpty() && value.charAt(0) == ' ') {
                    value = value.replaceFirst(" ", EMPTY_STRING);
                }
                this.processField(field, value);
            } else {
                this.processField(line.trim(), EMPTY_STRING);
            }
        }
    }

    private void processComment(String comment) {
        try {
            this.handler.onComment(comment);
        }
        catch (Exception e) {
            this.handler.onError(e);
        }
    }

    private void processField(String field, String value) {
        if (DATA.equals(field)) {
            this.data.append(value).append("\n");
        } else if (ID.equals(field)) {
            this.lastEventId = value;
        } else if (EVENT.equals(field)) {
            this.eventName = value;
        } else if (RETRY.equals(field) && this.isNumber(value)) {
            this.connectionHandler.setReconnectionTime(Duration.ofMillis(Long.parseLong(value)));
        }
    }

    private boolean isNumber(String value) {
        return DIGITS_ONLY.matcher(value).matches();
    }

    private void dispatchEvent() {
        if (this.data.length() == 0) {
            return;
        }
        String dataString = this.data.toString();
        if (dataString.endsWith("\n")) {
            dataString = dataString.substring(0, dataString.length() - 1);
        }
        MessageEvent message = new MessageEvent(dataString, this.lastEventId, this.origin);
        this.connectionHandler.setLastEventId(this.lastEventId);
        try {
            this.logger.debug("Dispatching message: \"{}\", {}", this.eventName, message);
            this.handler.onMessage(this.eventName, message);
        }
        catch (Exception e) {
            this.logger.warn("Message handler threw an exception: " + e.toString());
            this.logger.debug("Stack trace: {}", new LazyStackTrace(e));
            this.handler.onError(e);
        }
        this.data = new StringBuffer();
        this.eventName = DEFAULT_EVENT;
    }
}

