/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.eventsource;

import com.launchdarkly.eventsource.EventHandler;
import com.launchdarkly.eventsource.LazyStackTrace;
import com.launchdarkly.eventsource.Logger;
import com.launchdarkly.eventsource.MessageEvent;
import java.util.concurrent.Executor;

class AsyncEventHandler
implements EventHandler {
    private final Executor executor;
    private final EventHandler eventSourceHandler;
    private final Logger logger;

    AsyncEventHandler(Executor executor, EventHandler eventSourceHandler, Logger logger) {
        this.executor = executor;
        this.eventSourceHandler = eventSourceHandler;
        this.logger = logger;
    }

    @Override
    public void onOpen() {
        this.executor.execute(() -> {
            try {
                this.eventSourceHandler.onOpen();
            }
            catch (Exception e) {
                this.handleUnexpectedError(e);
            }
        });
    }

    @Override
    public void onClosed() {
        this.executor.execute(() -> {
            try {
                this.eventSourceHandler.onClosed();
            }
            catch (Exception e) {
                this.handleUnexpectedError(e);
            }
        });
    }

    @Override
    public void onComment(String comment) {
        this.executor.execute(() -> {
            try {
                this.eventSourceHandler.onComment(comment);
            }
            catch (Exception e) {
                this.handleUnexpectedError(e);
            }
        });
    }

    @Override
    public void onMessage(String event, MessageEvent messageEvent) {
        this.executor.execute(() -> {
            try {
                this.eventSourceHandler.onMessage(event, messageEvent);
            }
            catch (Exception e) {
                this.handleUnexpectedError(e);
            }
        });
    }

    @Override
    public void onError(Throwable error) {
        this.executor.execute(() -> this.onErrorInternal(error));
    }

    private void handleUnexpectedError(Throwable error) {
        this.logger.warn("Caught unexpected error from EventHandler: " + error.toString());
        this.logger.debug("Stack trace: {}", new LazyStackTrace(error));
        this.onErrorInternal(error);
    }

    private void onErrorInternal(Throwable error) {
        try {
            this.eventSourceHandler.onError(error);
        }
        catch (Throwable errorFromErrorHandler) {
            this.logger.warn("Caught unexpected error from EventHandler.onError(): " + errorFromErrorHandler.toString());
            this.logger.debug("Stack trace: {}", new LazyStackTrace(error));
        }
    }
}

