/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk;

import com.launchdarkly.sdk.EvaluationDetailTypeAdapterFactory;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.LDValueBool;
import com.launchdarkly.sdk.json.JsonSerializable;
import com.launchdarkly.shaded.com.google.gson.annotations.JsonAdapter;
import java.util.ArrayList;
import java.util.Objects;

@JsonAdapter(value=EvaluationDetailTypeAdapterFactory.class)
public final class EvaluationDetail<T>
implements JsonSerializable {
    public static final int NO_VARIATION = -1;
    private static final Iterable<EvaluationDetail<?>> BOOLEAN_SINGLETONS = EvaluationDetail.createBooleanSingletons();
    private final T value;
    private final int variationIndex;
    private final EvaluationReason reason;

    private EvaluationDetail(T value, int variationIndex, EvaluationReason reason) {
        this.value = value;
        this.variationIndex = variationIndex >= 0 ? variationIndex : -1;
        this.reason = reason;
    }

    public static <T> EvaluationDetail<T> fromValue(T value, int variationIndex, EvaluationReason reason) {
        if (value != null && (value.getClass() == Boolean.class || value.getClass() == LDValueBool.class)) {
            for (EvaluationDetail<?> d : BOOLEAN_SINGLETONS) {
                if (d.value != value || d.variationIndex != variationIndex || d.reason != reason) continue;
                return d;
            }
        }
        return new EvaluationDetail<T>(value, variationIndex, reason);
    }

    public static EvaluationDetail<LDValue> error(EvaluationReason.ErrorKind errorKind, LDValue defaultValue) {
        return new EvaluationDetail<LDValue>(LDValue.normalize(defaultValue), -1, EvaluationReason.error(errorKind));
    }

    public EvaluationReason getReason() {
        return this.reason;
    }

    public int getVariationIndex() {
        return this.variationIndex;
    }

    public T getValue() {
        return this.value;
    }

    public boolean isDefaultValue() {
        return this.variationIndex < 0;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof EvaluationDetail) {
            EvaluationDetail o = (EvaluationDetail)other;
            return Objects.equals(this.reason, o.reason) && this.variationIndex == o.variationIndex && Objects.equals(this.value, o.value);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.reason, this.variationIndex, this.value);
    }

    public String toString() {
        return "{" + this.value + "," + this.variationIndex + "," + this.reason + "}";
    }

    private static Iterable<EvaluationDetail<?>> createBooleanSingletons() {
        ArrayList ret = new ArrayList();
        for (int iFalseVariation = 0; iFalseVariation < 2; ++iFalseVariation) {
            for (int iOffVariation = 0; iOffVariation < 2; ++iOffVariation) {
                for (int iTruth = 0; iTruth < 2; ++iTruth) {
                    for (int iType = 0; iType < 2; ++iType) {
                        Object value = iType == 0 ? LDValue.of(iTruth == 1) : Boolean.valueOf(iTruth == 1);
                        int variationIndex = iTruth == 0 ? iFalseVariation : 1 - iFalseVariation;
                        EvaluationReason reason = variationIndex == iOffVariation ? EvaluationReason.off() : EvaluationReason.fallthrough();
                        ret.add(new EvaluationDetail<Object>(value, variationIndex, reason));
                    }
                }
            }
        }
        return ret;
    }
}

