/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.json;

import com.google.gson.stream.JsonWriter;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;

abstract class GsonWriterAdapter
extends JsonWriter {
    GsonWriterAdapter() {
        super(GsonWriterAdapter.makeStubWriter());
    }

    private static final Writer makeStubWriter() {
        return new CharArrayWriter(0);
    }

    public JsonWriter beginArray() throws IOException {
        this.beginArrayInternal();
        return this;
    }

    public JsonWriter beginObject() throws IOException {
        this.beginObjectInternal();
        return this;
    }

    public JsonWriter endArray() throws IOException {
        this.endArrayInternal();
        return this;
    }

    public JsonWriter endObject() throws IOException {
        this.endObjectInternal();
        return this;
    }

    public JsonWriter jsonValue(String value) throws IOException {
        this.jsonValueInternal(value);
        return this;
    }

    public JsonWriter name(String name) throws IOException {
        this.nameInternal(name);
        return this;
    }

    public JsonWriter nullValue() throws IOException {
        this.valueInternalNull();
        return this;
    }

    public JsonWriter value(boolean value) throws IOException {
        this.valueInternalBool(value);
        return this;
    }

    public JsonWriter value(Boolean value) throws IOException {
        if (value == null) {
            this.valueInternalNull();
        } else {
            this.valueInternalBool(value);
        }
        return this;
    }

    public JsonWriter value(double value) throws IOException {
        long asLong = (long)value;
        if (value == (double)asLong) {
            this.valueInternalLong(asLong);
        } else {
            this.valueInternalDouble(value);
        }
        return this;
    }

    public JsonWriter value(long value) throws IOException {
        this.valueInternalLong(value);
        return this;
    }

    public JsonWriter value(Number value) throws IOException {
        if (value == null) {
            this.valueInternalNull();
        } else {
            this.value(value.doubleValue());
        }
        return this;
    }

    public JsonWriter value(String value) throws IOException {
        this.valueInternalString(value);
        return this;
    }

    public void close() throws IOException {
    }

    protected abstract void beginArrayInternal() throws IOException;

    protected abstract void beginObjectInternal() throws IOException;

    protected abstract void endArrayInternal() throws IOException;

    protected abstract void endObjectInternal() throws IOException;

    protected abstract void jsonValueInternal(String var1) throws IOException;

    protected abstract void nameInternal(String var1) throws IOException;

    protected abstract void valueInternalNull() throws IOException;

    protected abstract void valueInternalBool(boolean var1) throws IOException;

    protected abstract void valueInternalDouble(double var1) throws IOException;

    protected abstract void valueInternalLong(long var1) throws IOException;

    protected abstract void valueInternalString(String var1) throws IOException;
}

