/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk;

import com.google.gson.annotations.JsonAdapter;
import com.launchdarkly.sdk.ContextKindTypeAdapter;
import com.launchdarkly.sdk.json.JsonSerializable;

@JsonAdapter(value=ContextKindTypeAdapter.class)
public final class ContextKind
implements Comparable<ContextKind>,
JsonSerializable {
    public static final ContextKind DEFAULT = new ContextKind("user");
    public static final ContextKind MULTI = new ContextKind("multi");
    private final String kindName;

    private ContextKind(String kindName) {
        this.kindName = kindName;
    }

    public static ContextKind of(String stringValue) {
        if (stringValue == null || stringValue.isEmpty() || stringValue.equals(ContextKind.DEFAULT.kindName)) {
            return DEFAULT;
        }
        if (stringValue.equals(ContextKind.MULTI.kindName)) {
            return MULTI;
        }
        return new ContextKind(stringValue);
    }

    public boolean isDefault() {
        return this == DEFAULT;
    }

    public String toString() {
        return this.kindName;
    }

    public boolean equals(Object other) {
        return other instanceof ContextKind && (this == other || this.kindName.equals(((ContextKind)other).kindName));
    }

    public int hashCode() {
        return this.kindName.hashCode();
    }

    String validateAsSingleKind() {
        if (this.isDefault()) {
            return null;
        }
        if (this == MULTI) {
            return "context of kind \"multi\" must be created with NewMulti or NewMultiBuilder";
        }
        if (this.kindName.equals("kind")) {
            return "\"kind\" is not a valid context kind";
        }
        for (int i = 0; i < this.kindName.length(); ++i) {
            char ch = this.kindName.charAt(i);
            if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9' || ch == '.' || ch == '_' || ch == '-') continue;
            return "context kind contains disallowed characters";
        }
        return null;
    }

    @Override
    public int compareTo(ContextKind o) {
        return this.kindName.compareTo(o.kindName);
    }
}

