/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android.subsystems;

import com.launchdarkly.logging.LDLogger;
import com.launchdarkly.sdk.LDContext;
import com.launchdarkly.sdk.android.LDConfig;
import com.launchdarkly.sdk.android.env.IEnvironmentReporter;
import com.launchdarkly.sdk.android.interfaces.ServiceEndpoints;
import com.launchdarkly.sdk.android.subsystems.DataSourceUpdateSink;
import com.launchdarkly.sdk.android.subsystems.HttpConfiguration;

public class ClientContext {
    private final IEnvironmentReporter environmentReporter;
    private final LDLogger baseLogger;
    private final LDConfig config;
    private final DataSourceUpdateSink dataSourceUpdateSink;
    private final boolean evaluationReasons;
    private final String environmentName;
    private final LDContext evaluationContext;
    private final HttpConfiguration http;
    private final boolean inBackground;
    private final String mobileKey;
    private final Boolean previouslyInBackground;
    private final ServiceEndpoints serviceEndpoints;
    private final boolean setOffline;

    public ClientContext(String mobileKey, IEnvironmentReporter environmentReporter, LDLogger baseLogger, LDConfig config, DataSourceUpdateSink dataSourceUpdateSink, String environmentName, boolean evaluationReasons, LDContext evaluationContext, HttpConfiguration http, boolean inBackground, Boolean previouslyInBackground, ServiceEndpoints serviceEndpoints, boolean setOffline) {
        this.mobileKey = mobileKey;
        this.environmentReporter = environmentReporter;
        this.baseLogger = baseLogger;
        this.config = config;
        this.dataSourceUpdateSink = dataSourceUpdateSink;
        this.environmentName = environmentName;
        this.evaluationReasons = evaluationReasons;
        this.evaluationContext = evaluationContext;
        this.http = http;
        this.inBackground = inBackground;
        this.previouslyInBackground = previouslyInBackground;
        this.serviceEndpoints = serviceEndpoints;
        this.setOffline = setOffline;
    }

    protected ClientContext(ClientContext copy) {
        this(copy.mobileKey, copy.environmentReporter, copy.baseLogger, copy.config, copy.dataSourceUpdateSink, copy.environmentName, copy.evaluationReasons, copy.evaluationContext, copy.http, copy.inBackground, copy.previouslyInBackground, copy.serviceEndpoints, copy.setOffline);
    }

    protected ClientContext setEvaluationContext(LDContext context) {
        return new ClientContext(this.mobileKey, this.environmentReporter, this.baseLogger, this.config, this.dataSourceUpdateSink, this.environmentName, this.evaluationReasons, context, this.http, this.inBackground, this.previouslyInBackground, this.serviceEndpoints, this.setOffline);
    }

    public IEnvironmentReporter getEnvironmentReporter() {
        return this.environmentReporter;
    }

    public LDLogger getBaseLogger() {
        return this.baseLogger;
    }

    public LDConfig getConfig() {
        return this.config;
    }

    public DataSourceUpdateSink getDataSourceUpdateSink() {
        return this.dataSourceUpdateSink;
    }

    public String getEnvironmentName() {
        return this.environmentName;
    }

    public boolean isEvaluationReasons() {
        return this.evaluationReasons;
    }

    public HttpConfiguration getHttp() {
        return this.http;
    }

    public LDContext getEvaluationContext() {
        return this.evaluationContext;
    }

    public boolean isInBackground() {
        return this.inBackground;
    }

    public String getMobileKey() {
        return this.mobileKey;
    }

    public Boolean getPreviouslyInBackground() {
        return this.previouslyInBackground;
    }

    public ServiceEndpoints getServiceEndpoints() {
        return this.serviceEndpoints;
    }

    public boolean isSetOffline() {
        return this.setOffline;
    }
}

