/*
 * Decompiled with CFR 0.152.
 */
package com.launchdarkly.sdk.android;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.launchdarkly.sdk.EvaluationReason;
import com.launchdarkly.sdk.LDValue;
import com.launchdarkly.sdk.internal.GsonHelpers;
import com.launchdarkly.sdk.json.SerializationException;
import java.util.Objects;

public abstract class DataModel {
    private DataModel() {
    }

    public static final class Flag {
        @NonNull
        private final String key;
        private final LDValue value;
        private final int version;
        private final Integer flagVersion;
        private final Integer variation;
        private final EvaluationReason reason;
        private final Boolean trackEvents;
        private final Boolean trackReason;
        private final Long debugEventsUntilDate;
        private final String[] prerequisites;
        private final Boolean deleted;

        private Flag(@NonNull String key, LDValue value, int version, Integer flagVersion, Integer variation, EvaluationReason reason, boolean trackEvents, boolean trackReason, Long debugEventsUntilDate, String[] prerequisites, boolean deleted) {
            this.key = key;
            this.value = value;
            this.version = version;
            this.flagVersion = flagVersion;
            this.variation = variation;
            this.reason = reason;
            this.trackEvents = trackEvents ? Boolean.TRUE : null;
            this.trackReason = trackReason ? Boolean.TRUE : null;
            this.debugEventsUntilDate = debugEventsUntilDate;
            this.prerequisites = prerequisites;
            this.deleted = deleted ? Boolean.TRUE : null;
        }

        public Flag(@NonNull String key, @NonNull LDValue value, int version, @Nullable Integer flagVersion, @Nullable Integer variation, boolean trackEvents, boolean trackReason, @Nullable Long debugEventsUntilDate, @Nullable EvaluationReason reason, @Nullable String[] prerequisites) {
            this(key, value, version, flagVersion, variation, reason, trackEvents, trackReason, debugEventsUntilDate, prerequisites, false);
        }

        public static Flag deletedItemPlaceholder(@NonNull String key, int version) {
            return new Flag(key, null, version, null, null, null, false, false, null, null, true);
        }

        String getKey() {
            return this.key;
        }

        @NonNull
        LDValue getValue() {
            return LDValue.normalize((LDValue)this.value);
        }

        int getVersion() {
            return this.version;
        }

        Integer getFlagVersion() {
            return this.flagVersion;
        }

        Integer getVariation() {
            return this.variation;
        }

        @Nullable
        EvaluationReason getReason() {
            return this.reason;
        }

        boolean isTrackEvents() {
            return this.trackEvents != null && this.trackEvents != false;
        }

        boolean isTrackReason() {
            return this.trackReason != null && this.trackReason != false;
        }

        @Nullable
        Long getDebugEventsUntilDate() {
            return this.debugEventsUntilDate;
        }

        int getVersionForEvents() {
            return this.flagVersion == null ? this.version : this.flagVersion;
        }

        @Nullable
        String[] getPrerequisites() {
            return this.prerequisites;
        }

        boolean isDeleted() {
            return this.deleted != null && this.deleted != false;
        }

        public String toString() {
            return this.toJson();
        }

        public boolean equals(Object other) {
            if (other instanceof Flag) {
                Flag o = (Flag)other;
                return Objects.equals(this.key, o.key) && Objects.equals(this.value, o.value) && this.version == o.version && Objects.equals(this.variation, o.variation) && Objects.equals(this.reason, o.reason) && this.trackEvents == o.trackEvents && this.trackReason == o.trackReason && Objects.equals(this.debugEventsUntilDate, o.debugEventsUntilDate) && Objects.equals(this.prerequisites, o.prerequisites) && this.deleted == o.deleted;
            }
            return false;
        }

        public static Flag fromJson(String json) throws SerializationException {
            try {
                return (Flag)GsonHelpers.gsonInstance().fromJson(json, Flag.class);
            }
            catch (Exception e) {
                throw new SerializationException((Throwable)e);
            }
        }

        public String toJson() {
            return GsonHelpers.gsonInstance().toJson((Object)this);
        }
    }
}

