/*
 * Decompiled with CFR 0.152.
 */
package com.kp.md.picker.utilities;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.support.v4.view.ViewCompat;
import android.util.Log;
import android.view.ContextThemeWrapper;
import android.view.View;
import android.widget.ImageView;
import com.kp.md.picker.R;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class MUtils {
    private static final String TAG = MUtils.class.getSimpleName();
    public static int COLOR_ACCENT;
    public static int COLOR_CONTROL_HIGHLIGHT;
    public static int COLOR_CONTROL_ACTIVATED;
    public static int COLOR_BUTTON_NORMAL;
    public static int COLOR_TEXT_PRIMARY;
    public static int COLOR_TEXT_PRIMARY_INVERSE;
    public static int COLOR_PRIMARY;
    public static int COLOR_PRIMARY_DARK;
    public static int COLOR_TEXT_SECONDARY;
    public static int COLOR_BACKGROUND;
    public static int COLOR_TEXT_SECONDARY_INVERSE;
    public static int CORNER_RADIUS;
    public static final int CORNER_TOP_LEFT = 1;
    public static final int CORNER_TOP_RIGHT = 2;
    public static final int CORNER_BOTTOM_RIGHT = 4;
    public static final int CORNER_BOTTOM_LEFT = 8;
    public static final int CORNERS_ALL = 15;
    public static final int STATE_ENABLED = 1;
    public static final int STATE_ACTIVATED = 2;
    public static final int STATE_PRESSED = 4;
    private static final int[][] STATE_SETS;
    private static final String DATE_FORMAT = "MM/dd/yyyy";
    private static final DateFormat DATE_FORMATTER;
    private static final int CHANGE_YEAR = 1582;

    public static void initializeResources(Context context) {
        TypedArray a = context.obtainStyledAttributes(new int[]{R.attr.colorAccent, R.attr.colorControlHighlight, R.attr.colorControlActivated, R.attr.colorButtonNormal, 16842806, 16842809, R.attr.colorPrimary, R.attr.colorPrimaryDark, 16842808, 0x1010031, 16842810});
        if (a.hasValue(0)) {
            COLOR_ACCENT = a.getColor(0, 0);
        }
        if (a.hasValue(1)) {
            COLOR_CONTROL_HIGHLIGHT = a.getColor(1, 0);
        }
        if (a.hasValue(2)) {
            COLOR_CONTROL_ACTIVATED = a.getColor(2, 0);
        }
        if (a.hasValue(3)) {
            COLOR_BUTTON_NORMAL = a.getColor(3, 0);
        }
        if (a.hasValue(4)) {
            COLOR_TEXT_PRIMARY = a.getColor(4, 0);
        }
        if (a.hasValue(5)) {
            COLOR_TEXT_PRIMARY_INVERSE = a.getColor(5, 0);
        }
        if (a.hasValue(6)) {
            COLOR_PRIMARY = a.getColor(6, 0);
        }
        if (a.hasValue(7)) {
            COLOR_PRIMARY_DARK = a.getColor(7, 0);
        }
        if (a.hasValue(8)) {
            COLOR_TEXT_SECONDARY = a.getColor(8, 0);
        }
        if (a.hasValue(9)) {
            COLOR_BACKGROUND = a.getColor(9, 0);
        }
        if (a.hasValue(10)) {
            COLOR_TEXT_SECONDARY_INVERSE = a.getColor(10, 0);
        }
        a.recycle();
        CORNER_RADIUS = context.getResources().getDimensionPixelSize(R.dimen.control_corner_material);
    }

    public static boolean isApi_16_OrHigher() {
        return Build.VERSION.SDK_INT >= 16;
    }

    public static boolean isApi_17_OrHigher() {
        return Build.VERSION.SDK_INT >= 17;
    }

    public static boolean isApi_18_OrHigher() {
        return Build.VERSION.SDK_INT >= 18;
    }

    public static boolean isApi_21_OrHigher() {
        return Build.VERSION.SDK_INT >= 21;
    }

    public static boolean isApi_22_OrHigher() {
        return Build.VERSION.SDK_INT >= 22;
    }

    public static boolean isApi_23_OrHigher() {
        return Build.VERSION.SDK_INT >= 23;
    }

    public static void setViewBackground(View view, Drawable bg) {
        int paddingL = view.getPaddingLeft();
        int paddingT = view.getPaddingTop();
        int paddingR = view.getPaddingRight();
        int paddingB = view.getPaddingBottom();
        if (MUtils.isApi_16_OrHigher()) {
            view.setBackground(bg);
        } else {
            view.setBackgroundDrawable(bg);
        }
        view.setPadding(paddingL, paddingT, paddingR, paddingB);
    }

    public static Drawable createButtonBg(Context context, int colorButtonNormal, int colorControlHighlight) {
        if (MUtils.isApi_21_OrHigher()) {
            return MUtils.createButtonRippleBg(context, colorButtonNormal, colorControlHighlight);
        }
        return MUtils.createButtonNormalBg(context, colorControlHighlight);
    }

    @TargetApi(value=21)
    private static Drawable createButtonRippleBg(Context context, int colorButtonNormal, int colorControlHighlight) {
        return new RippleDrawable(ColorStateList.valueOf((int)colorControlHighlight), null, MUtils.createButtonShape(context, colorButtonNormal));
    }

    private static Drawable createButtonNormalBg(Context context, int colorControlHighlight) {
        StateListDrawable sld = new StateListDrawable();
        sld.addState(new int[]{16842919}, MUtils.createButtonShape(context, colorControlHighlight));
        sld.addState(new int[0], (Drawable)new ColorDrawable(0));
        return sld;
    }

    private static Drawable createButtonShape(Context context, int color2) {
        int paddingH = context.getResources().getDimensionPixelSize(R.dimen.button_padding_horizontal_material);
        int paddingV = context.getResources().getDimensionPixelSize(R.dimen.button_padding_vertical_material);
        int insetH = context.getResources().getDimensionPixelSize(R.dimen.button_inset_horizontal_material);
        int insetV = context.getResources().getDimensionPixelSize(R.dimen.button_inset_vertical_material);
        float[] outerRadii = new float[8];
        Arrays.fill(outerRadii, (float)CORNER_RADIUS);
        RoundRectShape r = new RoundRectShape(outerRadii, null, null);
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)r);
        shapeDrawable.getPaint().setColor(color2);
        shapeDrawable.setPadding(paddingH, paddingV, paddingH, paddingV);
        return new InsetDrawable((Drawable)shapeDrawable, insetH, insetV, insetH, insetV);
    }

    public static Drawable createImageViewBg(int colorButtonNormal, int colorControlHighlight) {
        if (MUtils.isApi_21_OrHigher()) {
            return MUtils.createImageViewRippleBg(colorButtonNormal, colorControlHighlight);
        }
        return MUtils.createImageViewNormalBg(colorControlHighlight);
    }

    @TargetApi(value=21)
    private static Drawable createImageViewRippleBg(int colorButtonNormal, int colorControlHighlight) {
        return new RippleDrawable(ColorStateList.valueOf((int)colorControlHighlight), null, MUtils.createImageViewShape(colorButtonNormal));
    }

    private static Drawable createImageViewNormalBg(int colorControlHighlight) {
        StateListDrawable sld = new StateListDrawable();
        sld.addState(new int[]{16842919}, MUtils.createImageViewShape(colorControlHighlight));
        sld.addState(new int[0], (Drawable)new ColorDrawable(0));
        return sld;
    }

    private static Drawable createImageViewShape(int color2) {
        OvalShape ovalShape = new OvalShape();
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)ovalShape);
        shapeDrawable.getPaint().setColor(color2);
        return shapeDrawable;
    }

    public static int constrain(int amount, int low, int high) {
        return amount < low ? low : (amount > high ? high : amount);
    }

    public static long constrain(long amount, long low, long high) {
        return amount < low ? low : (amount > high ? high : amount);
    }

    public static boolean isLayoutRtlCompat(@NonNull View view) {
        return ViewCompat.getLayoutDirection((View)view) == 1;
    }

    public static Drawable createBgDrawable(int color2, int rTopLeft, int rTopRight, int rBottomRight, int rBottomLeft) {
        float[] outerRadii = new float[]{rTopLeft, rTopLeft, rTopRight, rTopRight, rBottomRight, rBottomRight, rBottomLeft, rBottomLeft};
        RoundRectShape r = new RoundRectShape(outerRadii, null, null);
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)r);
        shapeDrawable.getPaint().setColor(color2);
        return shapeDrawable;
    }

    public static Drawable createOverflowButtonBg(int pressedStateColor) {
        if (MUtils.isApi_21_OrHigher()) {
            return MUtils.createOverflowButtonBgLollipop(pressedStateColor);
        }
        return MUtils.createOverflowButtonBgBC(pressedStateColor);
    }

    @TargetApi(value=21)
    private static Drawable createOverflowButtonBgLollipop(int pressedStateColor) {
        return new RippleDrawable(ColorStateList.valueOf((int)pressedStateColor), null, null);
    }

    private static Drawable createOverflowButtonBgBC(int pressedStateColor) {
        StateListDrawable sld = new StateListDrawable();
        sld.addState(new int[]{16842919}, MUtils.createBgDrawable(pressedStateColor, 0, CORNER_RADIUS, 0, 0));
        sld.addState(new int[0], (Drawable)new ColorDrawable(0));
        return sld;
    }

    public static Calendar getCalendarForLocale(Calendar oldCalendar, Locale locale) {
        if (oldCalendar == null) {
            return Calendar.getInstance(locale);
        }
        long currentTimeMillis = oldCalendar.getTimeInMillis();
        Calendar newCalendar = Calendar.getInstance(locale);
        newCalendar.setTimeInMillis(currentTimeMillis);
        return newCalendar;
    }

    public static ContextThemeWrapper createThemeWrapper(Context context, int parentStyleAttr, int parentDefaultStyle, int childStyleAttr, int childDefaultStyle) {
        TypedArray forParent = context.obtainStyledAttributes(new int[]{parentStyleAttr});
        int parentStyle = forParent.getResourceId(0, parentDefaultStyle);
        forParent.recycle();
        TypedArray forChild = context.obtainStyledAttributes(parentStyle, new int[]{childStyleAttr});
        int childStyleId = forChild.getResourceId(0, childDefaultStyle);
        forChild.recycle();
        return new ContextThemeWrapper(context, childStyleId);
    }

    public static void setViewBackground(View view, int bgColor, int corners) {
        if (MUtils.isApi_21_OrHigher()) {
            view.setBackgroundColor(bgColor);
        } else {
            MUtils.setViewBackground(view, MUtils.createBgDrawable(bgColor, (corners & 1) != 0 ? CORNER_RADIUS : 0, (corners & 2) != 0 ? CORNER_RADIUS : 0, (corners & 4) != 0 ? CORNER_RADIUS : 0, (corners & 8) != 0 ? CORNER_RADIUS : 0));
        }
    }

    public static void setImageTintList(ImageView imageView, ColorStateList colorStateList) {
        if (MUtils.isApi_21_OrHigher()) {
            imageView.setImageTintList(colorStateList);
        } else {
            Drawable drawable2 = imageView.getDrawable();
            if (drawable2 != null) {
                Drawable wrapped = DrawableCompat.wrap((Drawable)drawable2);
                DrawableCompat.setTintList((Drawable)wrapped, (ColorStateList)colorStateList);
                imageView.setImageDrawable(wrapped);
            }
        }
    }

    public static int[] resolveStateSet(int mask) {
        return STATE_SETS[mask];
    }

    public static boolean parseDate(String date, Calendar outDate) {
        if (date == null || date.isEmpty()) {
            return false;
        }
        try {
            Date parsedDate = DATE_FORMATTER.parse(date);
            outDate.setTime(parsedDate);
            return true;
        }
        catch (ParseException e) {
            Log.w((String)TAG, (String)("Date: " + date + " not in format: " + DATE_FORMAT));
            return false;
        }
    }

    private static boolean isLeapYear(int year) {
        if (year > 1582) {
            return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0);
        }
        return year % 4 == 0;
    }

    public static int getDaysInMonth(int month, int year) {
        switch (month) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return 31;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                return 30;
            }
            case 1: {
                return MUtils.isLeapYear(year) ? 29 : 28;
            }
        }
        throw new IllegalArgumentException("Invalid Month");
    }

    @TargetApi(value=21)
    public static void vibrateForDatePicker(View view) {
        view.performHapticFeedback(1);
    }

    @TargetApi(value=21)
    public static void vibrateForTimePicker(View view) {
        view.performHapticFeedback(MUtils.isApi_21_OrHigher() ? 4 : 1);
    }

    static {
        STATE_SETS = new int[8][];
        MUtils.STATE_SETS[0] = new int[]{0};
        MUtils.STATE_SETS[1] = new int[]{16842910};
        MUtils.STATE_SETS[2] = new int[]{16843518};
        MUtils.STATE_SETS[3] = new int[]{16842910, 16843518};
        MUtils.STATE_SETS[4] = new int[]{16842919};
        MUtils.STATE_SETS[5] = new int[]{16842910, 16842919};
        MUtils.STATE_SETS[6] = new int[]{16843518, 16842919};
        MUtils.STATE_SETS[7] = new int[]{16842910, 16843518, 16842919};
        DATE_FORMATTER = new SimpleDateFormat(DATE_FORMAT);
    }
}

