/*
 * Decompiled with CFR 0.152.
 */
package com.kp.md.picker.utilities;

import android.content.Context;
import android.support.v4.view.accessibility.AccessibilityEventCompat;
import android.support.v4.view.accessibility.AccessibilityRecordCompat;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import com.kp.md.picker.utilities.MUtils;

public class AccessibilityUtils {
    public static void makeAnnouncement(View view, CharSequence announcement) {
        if (view == null) {
            return;
        }
        if (MUtils.isApi_16_OrHigher()) {
            view.announceForAccessibility(announcement);
        } else {
            Context ctx = view.getContext();
            AccessibilityManager am = (AccessibilityManager)ctx.getSystemService("accessibility");
            if (!am.isEnabled()) {
                return;
            }
            AccessibilityEvent event = AccessibilityEvent.obtain((int)64);
            AccessibilityRecordCompat arc = AccessibilityEventCompat.asRecord((AccessibilityEvent)event);
            arc.setSource(view);
            event.setClassName((CharSequence)view.getClass().getName());
            event.setPackageName((CharSequence)view.getContext().getPackageName());
            event.setEnabled(view.isEnabled());
            event.getText().add(announcement);
            am.sendAccessibilityEvent(event);
        }
    }
}

